#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"

void
mat_ring_scalar_right_mult_sub WITH_4_ARGS(
	t_handle,		cring,
	matrix,		a,
	t_ring_elt,	b,
	matrix*,	pc
)
/*
** *pc = a * b, b element of cring, a matrix over cring.
*/
{
	block_declarations;
	register t_int		dsq;
	register t_int		i;
	t_int		m;
	t_int		n;
	Logical	respack;
	matrix	mata;
	matrix	matc;
	t_ring_elt	(*ringmult)();

	mata = matc = 0;

	ringmult = ring_multiplication( cring );
	m = mat_row(a);
	n = mat_col(a);

	respack = mat_result_pkd(cring, *pc);
	mat_alloc_result_unpkd(respack, *pc, matc, m, n);
	mat_create_unpkd(cring, a, mata, m, n);

	dsq = m * n;
	for (i = 1; i <= dsq; i++)
	{
		mat_entry(matc, i) = (*ringmult)(cring, mat_entry(mata, i), b);
	}

	mat_create_result(cring, respack, *pc, matc);
	mat_free_unpkd(a, mata);
}


matrix
mat_ring_scalar_right_mult WITH_3_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b
)
/*
** *pc = a * b, b element of cring, a matrix over cring.
*/
{
	matrix c = 0;
	mat_ring_scalar_right_mult_sub(cring, a, b, &c);
	return c;
}


void
mat_ring_scalar_left_mult_sub WITH_4_ARGS(
	t_handle,		cring,
	t_ring_elt,	b,
	matrix,		a,
	matrix*,	pc
)
/*
** *pc = b * a, b element of cring, a matrix over cring.
*/
{
	block_declarations;
	register t_int		dsq;
	register t_int		i;
	t_int		m;
	t_int		n;
	Logical	respack;
	matrix	mata;
	matrix	matc;
	t_ring_elt	(*ringmult)();

	mata = matc = 0;

	ringmult = ring_multiplication( cring );
	m = mat_row(a);
	n = mat_col(a);

	respack = mat_result_pkd(cring, *pc);
	mat_alloc_result_unpkd(respack, *pc, matc, m, n);
	mat_create_unpkd(cring, a, mata, m, n);

	dsq = m * n;
	for (i = 1; i <= dsq; i++)
	{
		mat_entry(matc, i) = (*ringmult)(cring, b, mat_entry(mata, i));
	}

	mat_create_result(cring, respack, *pc, matc);
	mat_free_unpkd(a, mata);
}


matrix
mat_ring_scalar_left_mult WITH_3_ARGS(
	t_handle,		cring,
	t_ring_elt,	b,
	matrix,		a
)
/*
** *pc = b * a, b element of cring, a matrix over cring.
*/
{
	matrix c = 0;
	mat_ring_scalar_left_mult_sub(cring, b, a, &c);
	return c;
}

