#include "defs.h"
#include "integer.e"
#include "inthdl_protos.h"
#include "intbig.h"
#include "modint.e"


integer_big
modint_exp (mint, aint, power)
integer_big	mint;
integer_big	aint;
integer_big	power;
/*
** MODINT_EXP: modular integer exponentiation
** returns aint ^ power mod mint
** mint, aint and power arbitrary precision integers
*/
{
    t_int		i, mask, dig;
    inthdl_length		buflen;
    inthdl_handle		modulus, rhdl, temp, ahdl, phdl, swap;
    t_logical			first, aint_is_single;


    if (power == 0)
    {
        return 1;
    }

    if (aint == 0)
    {
        return 0;
    }

    if (integer_is_single(mint))
    {
	buflen = 3;
	modulus = inthdl_buf_alloc(1);
	intbig_sign(modulus) = 1;
	intbig_curr_size(modulus) = 1;
	intbig_digit(modulus, 0) = mint;
    }
    else
    {
	modulus = inthdl_big_to_handle(mint);
	buflen = (intbig_curr_size(modulus) << 1) + 1;
    }

    rhdl = inthdl_buf_alloc(buflen);
    temp = inthdl_buf_alloc(buflen);

    if (aint_is_single = integer_is_single(aint))
    {
	aint = integer_rem(aint, mint);
	intbig_curr_size(rhdl) = 1;
	if (aint > 0)
	{
	    intbig_sign(rhdl) = 1;
	    intbig_digit(rhdl, 0) = aint;
	}
	else if (aint < 0)
	{
	    intbig_sign(rhdl) = -1;
	    intbig_digit(rhdl, 0) = -aint;
	}
    }
    else
    {
	ahdl = inthdl_big_to_handle(aint);
	inthdl_rem(ahdl, modulus, rhdl);
    }

    first = TRUE;

    if (integer_is_single(power))
    {
	i = 0;
	dig = power;
	goto KLUDGE;
    }

    phdl = inthdl_big_to_handle(power);
    for (i = intbig_curr_size(phdl) - 1; i >= 0; i--)
    {
	dig = intbig_digit(phdl, i);
KLUDGE:
	for (mask = 1 << (ZETA - 1); mask; mask >>= 1)
	{
	    if (first)
	    {
		if (dig & mask)
		    first = FALSE;
	    }
	    else
	    {
		inthdl_square(rhdl, temp);

		if (dig & mask)
		{
		    if (aint_is_single)
		    {
			inthdl_mult_beta(temp, aint, rhdl);
			swap = rhdl;
			rhdl = temp;
			temp = swap;
		    }
		    else
		    {
			inthdl_rem(temp, modulus, rhdl);
			inthdl_mult(rhdl, ahdl, temp);
		    }
		}
		inthdl_rem(temp, modulus, rhdl);
	    }
	}
    }

    inthdl_buf_delete(temp);
    if (integer_is_single(mint))
	inthdl_buf_delete(modulus);

    return inthdl_standardize(rhdl);
}
