#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "modint.e"

t_poly
modpoly_monic WITH_3_ARGS(
        t_handle,       pring,
	integer_big,	pdig,
	t_poly,	apoly
)
/*
** modpoly_monic : modular polynomial monic.
** apoly is a polynomial over Zpdig, pdig a prime integer.
** if apoly is non-zero then returns the polynomial similar to a with
** leading base coefft = 1. 
** if apoly = 0 then returns zero
*/
{
	block_declarations;
	integer_big     a;
	integer_big     adash;
	t_poly	result;

	if ( apoly == 0 )
	{
		return 0;
	}

	/* apoly non-zero polynomial */

	a = poly_z_lbase_coefft( pring, apoly );

	if ( a == 1 )
	{
		return  m_modpoly_incref( pring, apoly );
	}

	adash = modint_invert( pdig, a );
        integer_delref (a);

	result = modpoly_integer_mult( pring, pdig, apoly, adash );
	integer_delref( adash );

	return result;
}

