
#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
modpoly_uni_mult WITH_4_ARGS(
        t_handle,         pring,
        integer_big,      pdig,
        t_poly,        apoly,
        t_poly,        unipoly
)
/*
** modpoly_uni_mult : modular polynomial univariate multiply.
** pdig: modulus of coefft ring
** apoly: non-zero polynomial in >= 2 variables over Zpdig.
** unipoly: univariate polynomial over Zpdig.
** returns modular product of apoly and unipoly.
*/
{
    t_poly        respoly;
    t_handle           resh;
    t_handle           aph;
    t_int    aterms;
    t_int    termno;
    t_poly        acoefft;

    aph = m_poly_poly_to_handle( apoly );
    aterms = m_poly_nterms( aph );
    m_poly_create_empty (&resh, m_poly_princvar (aph),
                                        m_poly_least_pvar (aph), aterms);
    respoly = m_poly_handle_to_poly (resh);
    acoefft = m_poly_coefft( aph, 0 );

    if (m_poly_univariate (m_poly_poly_to_handle (acoefft)))
    {
        for (termno = 0; termno < aterms; )
        {
            m_poly_expt (resh, termno) = m_poly_expt (aph, termno);
            m_poly_coefft (resh, termno) =
                          modpoly_mult (pring, pdig, acoefft, unipoly);
            termno ++;
            acoefft = m_poly_coefft( aph, termno );
        }
    }
    else
    {
        for (termno = 0; termno < aterms; )
        {
            m_poly_expt (resh, termno) = m_poly_expt (aph, termno);
            m_poly_coefft (resh, termno) =
                      modpoly_uni_mult (pring, pdig, acoefft, unipoly);
            termno ++;
            acoefft = m_poly_coefft( aph, termno );
        }
    }

    return poly_z_clean (pring, respoly);
}
