#include "defs.h"
#include "mp.e"
#include "mp.h"


mp_float
mp_daw		WITH_2_ARGS(
	mp_float,	x,
	mp_float,	y
)
/*
Returns y = Dawson's integral(x)
	  = exp(-x^2) * (integral from 0 to x of exp(u^2) du).
*/
{
    mp_ptr_type		xp = mp_ptr(x), yp = mp_ptr(y);
    mp_round_type	save_round = round;
    mp_base_type	b;
    mp_length		t, new_t;
    mp_sign_type	x_sign;
    mp_acc_float	temp1, temp2, temp3;
    mp_ptr_type		temp1_ptr, temp2_ptr, temp3_ptr;

    DEBUG_BEGIN(DEBUG_DAW);
    DEBUG_PRINTF_1("+daw {\n");
    DEBUG_1("x = ", xp);

    mp_check_2("mp_daw", xp, yp);

    if ((x_sign = mp_sign(xp)) == 0)
    {
	mp_set_sign(yp, 0);

	DEBUG_PRINTF_1("y = 0\n");
	DEBUG_END();

	return y;
    }

    b = mp_b(xp);
    t = mp_t(xp);

    round = MP_TRUNC;
    new_t = t + 1 + mp_extra_guard_digits(mp_times_log2_b(t, b), b);

    mp_acc_float_alloc_3(b, new_t, temp1, temp2, temp3);
    mp_change_up();

    mp_move(x, temp1);

    temp1_ptr = mp_acc_float_ptr(temp1);
    temp2_ptr = mp_acc_float_ptr(temp2);
    temp3_ptr = mp_acc_float_ptr(temp3);


#define fix_pointers()		if (mp_has_changed())			    \
				{					    \
				    temp1_ptr = mp_acc_float_ptr(temp1);    \
				    temp2_ptr = mp_acc_float_ptr(temp2);    \
				    temp3_ptr = mp_acc_float_ptr(temp3);    \
				}


    mp_set_sign(temp1_ptr, 1);


    /*
    Try asymptotic series.
    */

    if (mp_erf3(temp1, temp1, TRUE))
    {
	/*
	Asymptotic series was successful.  Fix sign.
	*/

	if (x_sign < 0)
	{
	    if (mp_has_changed())
		temp1_ptr = mp_acc_float_ptr(temp1);

	    mp_set_sign(temp1_ptr, -mp_sign(temp1_ptr));
	}
    }

    else
    {
	/*
	Use the power series.
	*/

	mp_int		i;


	mp_move(x, temp3);

	fix_pointers();
	mp_copy_ptr(temp3_ptr, temp1_ptr);

	mp_mul_eq(temp3, temp3);
	mp_neg(temp3, temp3);
	mp_exp(temp3, temp3);

	mp_mul(temp1, temp3, temp2);
	mp_mul(temp1, temp1, temp3);

	fix_pointers();
	mp_copy_ptr(temp2_ptr, temp1_ptr);

#if 0
	mp_set_digits_zero(mp_digit_ptr(temp2_ptr, t), new_t - t);
	mp_set_digits_zero(mp_digit_ptr(temp3_ptr, t), new_t - t);
#endif

	i = 1;

	do
	{
	    /*
	    Reduce t if possible for multiplications.
	    */

	    mp_length	mul_t = new_t + 2 + mp_expt(temp2_ptr) -
						     mp_expt(temp1_ptr);

	    if (mul_t <= 2)
		break;

	    if (mul_t > new_t)
		mul_t = new_t;

	    mp_t(temp2_ptr) = mp_t(temp3_ptr) = mul_t;


	    mp_mul_eq(temp2, temp3);
	    mp_mul_double_q(temp2, 2 * i - 1, 1, i, 2 * i + 1);


	    /*
	    Restore t of temp2 for addition.
	    */

	    fix_pointers();
	    mp_t(temp2_ptr) = new_t;

	    mp_add_eq(temp1, temp2);

	    i++;

	    fix_pointers();

	} while (!mp_is_zero(temp2_ptr));
    }


    round = save_round;
    mp_move_round(temp1, y);

    mp_acc_float_delete(temp3);
    mp_acc_float_delete(temp2);
    mp_acc_float_delete(temp1);
    mp_change_down();

    DEBUG_1("y = ", mp_ptr(y));
    DEBUG_END();

    return y;
}
