#include <stdio.h>
#include <varargs.h>

#include "defs.h"
#include "mp.e"
#include "mp.h"


/*
MAXSTRING should be length of longest possible error string.
*/

#define MAXSTRING	256


void mp_priv_error(va_alist)
va_dcl
/*
Sends the printf type string to the user callback function.
*/
{
    va_list	args;
    char	buf[MAXSTRING], *msg;

    va_start(args);

    msg = va_arg(args, char *);
    vsprintf(buf, msg, args);
    strcat(buf, "\n");

    va_end(args);

    mp_reset();
    (*mp_callback)(buf);
}



void mp_priv_bug(va_alist)
va_dcl
{
    va_list	args;
    char	buf[MAXSTRING], *msg;


    va_start(args);

    msg = va_arg(args, char *);
    vsprintf(buf, msg, args);
    strcat(buf, "\n");

    va_end(args);

    mp_reset();
    (*mp_callback)(buf);
}
