#include "poly.h"

t_logical
poly_eq(pring, apoly, bpoly)
t_handle	pring;
t_poly		apoly, bpoly;
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_eq_crf(&context, apoly, bpoly);
}

t_logical
poly_eq_crf(context, apoly, bpoly)
t_poly_ctx	context;
t_poly		apoly, bpoly;
{
	t_int		nterms;
	t_int		termno;
	t_polyp		ap, bp;
	t_int		aexpt;
	t_int		bexpt;
	t_pfl		elt_equal;
	t_handle	cring;
	t_int		univ;
	t_poly		acoeff, bcoeff;


	DENY ( m_poly_const( apoly ) || m_poly_const( bpoly ) );

	if (apoly == bpoly)
	{
		return TRUE;
	}

	ap = m_poly_to_ptr( apoly );
	bp = m_poly_to_ptr( bpoly );

	if ( m_polyp_princvar( ap ) != m_polyp_princvar( bp ) )
	{
		return  FALSE;
	}

	if ( m_polyp_least_pvar( ap ) != m_polyp_least_pvar( bp ) )
	{
		return  FALSE;
	}

	nterms = m_polyp_nterms(ap);
	if (nterms != m_polyp_nterms( bp ))
	{
		return FALSE;
	}

	univ  = m_polyp_univariate(ap);
	if (univ)
	{
		elt_equal = m_poly_ctx_elt_equal(context);
		cring = m_poly_ctx_cring(context);
	}

	for (termno = 0; termno < nterms; termno ++)
	{
		aexpt = m_polyp_expt( ap, termno );
		bexpt = m_polyp_expt( bp, termno );

		if ( aexpt != bexpt )
		{
			return  FALSE;
		}
		else
		{ 
			acoeff = m_polyp_coefft(ap,termno);
			bcoeff = m_polyp_coefft(bp,termno);

			if (univ)
			{
				if (!(*elt_equal)(cring, acoeff, 0, cring,  bcoeff, 0 ))
					return FALSE;
			}
			else
			{
				if (!poly_eq_crf(context,acoeff,bcoeff))
					return  FALSE;
			}
		}
	}

	return  TRUE;

} 

