#include "poly.h"

t_poly
poly_reductum (pring, apoly)
t_handle	pring;
t_poly		apoly;
/*
*    POLY_REDUCTUM: polynomial reductum
*    apoly is a polynomial
*    returns the reductum  of apoly
*    i.e. same poly but lacking the leading term
*/
{
	t_poly_context	context;

	poly_init_context(pring,  &context);
	return poly_reductum_crf(&context, apoly);
}

t_poly
poly_reductum_crf(context, apoly)
t_poly_ctx	context;
t_poly		apoly;
{
	t_polyp		ap, resp;
	t_handle	resph;
	t_int    	i;
	t_int		nterms;
	t_pfh		elt_incref;
	t_handle	cring;
	t_int		univ;

	DENY ( m_poly_const( apoly ) );
	elt_incref = m_poly_ctx_elt_incref(context);
	cring = m_poly_ctx_cring(context);

	/* if apoly is not a constant then remove the leading term */

	ap = m_poly_to_ptr( apoly );
	nterms = m_polyp_nterms( ap );
	DENY ( nterms == 0 );
	nterms--;

	m_poly_create_empty(&resph,m_polyp_princvar(ap),m_polyp_least_pvar(ap),nterms);
	resp = m_poly_hdl_to_ptr(resph);
	univ = m_polyp_univariate(ap);

	if (univ)
	{
		for ( i = 0; i < nterms; i++ )
		{
			m_polyp_coefft(resp, i) = (* elt_incref)(cring, m_polyp_coefft(ap, i));
			m_polyp_expt(resp, i) = m_polyp_expt(ap, i);
		}
		return  m_poly_handle_to_poly( resph );
	}
	for ( i = 0; i < nterms; i++ )
	{
		m_polyp_coefft(resp, i) = poly_elt_incref_crf(context, m_polyp_coefft(ap, i));
		m_polyp_expt(resp, i) = m_polyp_expt(ap, i);
	}
	return  m_poly_handle_to_poly( resph );
}

