#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_mat.h"
#include "zm.e"

t_void
poly_u_zm_d_mult WITH_8_ARGS(
	integer_big,		pdig,
	t_mat,			phdl,
	t_int,		deg1,
	t_int,		arg1,
	t_int,		deg2,
	t_int,		arg2,
	t_int *,	degres,
	t_int,		res
)
/*
** res := arg1 * arg2
*/
{
	block_declarations;
	t_int	i;
	t_int	j;
	t_int	k;
	integer_big	t1;
	integer_big	t2;
	integer_big	temp1;
	integer_big	temp2;
	t_int	resoff;
	t_int	arg1off;
	t_int	arg2off;
	t_int	len;

	len = m_poly_mat_col( phdl );

	DENY ( deg1 < 0 || deg2 < 0 );
	DENY( len < deg1 + deg2 - 1 );

	if ( deg1 == 0 || deg2 == 0 )
	{
		*degres = 0;
		return;
	}

	resoff = (res - 1) * len;
	arg1off = (arg1 - 1) * len;
	arg2off = (arg2 - 1) * len;

	DENY ( m_poly_mat_entry( phdl, arg1off + deg1 ) == 0 );
	DENY ( m_poly_mat_entry( phdl, arg2off + deg2 ) == 0 );

	for ( i = deg1 + deg2 - 1; i >= 1; --i )
	{
		temp1 = m_poly_mat_entry( phdl, resoff + i );
		integer_delref( temp1 );
		m_poly_mat_entry( phdl, resoff + i ) = 0;
	}

	/* this may not be needed */
	for ( i = deg1 + deg2; i <= len ; ++i )
	{
		temp1 = m_poly_mat_entry( phdl, resoff + i );
		integer_delref( temp1 );
		m_poly_mat_entry( phdl, resoff + i ) = 0;
	}

	for ( i=1; i<=deg1; ++i )
	{
		t1 = m_poly_mat_entry( phdl, arg1off + i );
		if ( t1 == 0 )
		{
			continue;
		}

		for ( j=1; j<=deg2; ++j )
		{
			t2 = m_poly_mat_entry( phdl, arg2off + j );
			if ( t2 == 0 )
			{
				continue;
			}

			k = i + j - 1;
			temp1 = m_poly_mat_entry( phdl, resoff + k );
			temp2 = modint_mult( pdig, t1, t2 );
			m_poly_mat_entry( phdl, resoff + k ) = modint_add( pdig, temp1, temp2 );
			integer_delref( temp2 );
			integer_delref( temp1 );
		}
	}

	for ( i = deg1 + deg2 - 1; ; --i )
	{
		if ( i == 0 || m_poly_mat_entry( phdl, resoff + i ) != 0 )
		{
			*degres = i;
			return;
		}
	}
}
