#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"
#include "debug.e"
#undef A



/* 
** bind/glue should check preconditions. If C is 0, preconditions
** wont hold 
*/

t_void 
debug_univ_chk( apoly)
t_poly	apoly;
/* 
** Register an error_internal if apoly is not univariant.
*/
{
	if ( m_poly_const (apoly))
		error_internal( "const poly found" );

	if ( ! m_poly_univariate (m_poly_poly_to_handle (apoly)) )
		error_internal( "expecting univariate polynomials" );

	return;

	
}

t_void
poly_u_zm_hensel_lemma WITH_10_ARGS(
        t_handle,       pring,	/* Zp[X] for prime number p. */
	integer_big,	p,
	t_poly,	A_bar,
	t_poly,	B_bar,
	t_poly,	S_bar,
	t_poly,	T_bar,
	integer_big,	M,
	t_poly,	C,
	t_poly *,	A,
	t_poly *,	B
)
/*
** See SAC code for details. This function is taken from 
** SAC's IUPQH - Integral univariate polynomial quadratic Hensel's
** Lemma.
*/
{
	t_poly	poly_temp, I;
	t_poly	R, S, T, U, R_dash;
	t_poly	A_tilde, B_tilde, S_tilde, T_tilde;
	t_poly	A_star, B_star;
	integer_big	q, q_star, q_tilde;
	t_int		c;
	t_poly	Y, Z, U1, Y1, Z1;
	t_poly	S_star, T_star;
	t_poly	tempa, tempb; 
	block_declarations;
	t_poly	abchk, dif, cp;
	t_poly	tempu;


	q_tilde = A_tilde = B_tilde = S_tilde = T_tilde = 0;
	A_star = B_star = 0;
	R_dash = R = U = Y = Z = 0;
	q_star = 0;
	A_star = B_star = 0;
	U1 = Y1 = Z1 = 0;
	S_star = T_star = 0;

#ifdef DEVELOP
	/* Checking preconditions */
	abchk = modpoly_mult(pring, p, A_bar, B_bar);
	cp = modpoly_hom(pring, p, C);
	dif = modpoly_subtract(pring, p, cp, abchk);

	ASSERT (poly_z_is_zero_poly(pring , dif));
	poly_z_elt_delete(pring, &dif);
	poly_z_elt_delete(pring, &cp);
	poly_z_elt_delete(pring, &abchk);
#endif

	/* 
	** The algorithm proper :
	** Step 1. Initialise the variables.
	*/
	/* For use when the ring is not bogus 
	q = integer_incref(zm_modulus(poly_coeff_ring(pring)));
	*/
	q = integer_incref(p);
	*A = m_poly_z_incref(pring, A_bar);
	*B = m_poly_z_incref(pring, B_bar);
	S = m_poly_z_incref(pring, S_bar);
	T = m_poly_z_incref(pring, T_bar);
	I = poly_z_constant_poly(pring, A_bar, 1);
	if (!integer_compare(q, M)) 
		return;

	/* Initialize variables to be delreffed. */
	while(1)
	{
		/*
		** Step 2: Compute Y and Z.
		*/
		poly_z_elt_delete(pring, &R);
		R = poly_z_mult(pring, *A, *B);

		poly_temp = R;
		R = poly_z_subtract(pring, C, poly_temp);
		poly_z_elt_delete(pring, &poly_temp);

		poly_z_elt_delete(pring, &U);
		U = poly_z_integer_div(pring, R, q);

		integer_delref(q_star);
		q_star = integer_mult(q,q);
		c = integer_compare(q_star, M);

		integer_delref( q_tilde);
		poly_z_elt_delete(pring, &A_tilde);
		poly_z_elt_delete(pring, &B_tilde);
		poly_z_elt_delete(pring, &S_tilde);
		poly_z_elt_delete(pring, &T_tilde);

		if (c>0)
		{
			q_tilde = integer_div(M,q);
			A_tilde = modpoly_hom(pring, q_tilde, *A);
			B_tilde = modpoly_hom(pring, q_tilde, *B);
			S_tilde = modpoly_hom(pring, q_tilde, S);
			T_tilde = modpoly_hom(pring, q_tilde, T);
		}
		else
		{
			q_tilde = integer_incref(q);
			A_tilde = m_poly_z_incref(pring, *A);
			B_tilde = m_poly_z_incref(pring, *B);
			S_tilde = m_poly_z_incref(pring, S);
			T_tilde = m_poly_z_incref(pring, T);
		}
		poly_z_elt_delete(pring, &Y);
		poly_z_elt_delete(pring, &Z);
		tempu = modpoly_hom(pring, q_tilde, U);
		poly_z_elt_delete(pring, &U);
		U = tempu;
		poly_u_zm_solve_eqn(pring,q_tilde,A_tilde,B_tilde,S_tilde,T_tilde,U, &Y, &Z);
		/* 
		** Step 3 : Compute A_star, B_star and check for end. 
		*/

		poly_z_elt_delete(pring, &R);
		R = poly_z_integer_mult(pring, Z, q);

		poly_z_elt_delete(pring, &A_star);
		poly_z_elt_delete(pring, &B_star);
		A_star = poly_z_add(pring, *A, R);

		poly_z_elt_delete(pring, &R);
		R = poly_z_integer_mult(pring, Y, q);

		B_star = poly_z_add(pring, *B, R);
		if (c>= 0)
		{
			*A = m_poly_z_incref(pring, A_star);
			*B = m_poly_z_incref(pring, B_star);
			goto end;
		}
		
		/*
		** Step 4 : Compute Y1 and Z1 
		*/
		poly_z_elt_delete(pring, &R);
		R = poly_z_mult(pring, A_star, S);

		poly_z_elt_delete(pring, &R_dash);
		R_dash = poly_z_mult(pring, B_star, T);

		poly_temp = R;
		R = poly_z_add(pring, R, R_dash);
		poly_z_elt_delete(pring, &poly_temp);

		poly_temp = R;
		R = poly_z_subtract(pring, poly_temp, I);
		poly_z_elt_delete(pring, &poly_temp);

		poly_z_elt_delete(pring, &U1);
		U1 = poly_z_integer_div(pring, R, q);

		poly_z_elt_delete(pring, &Y1);
		poly_z_elt_delete(pring, &Z1);
		tempu = modpoly_hom(pring, q, U1);
		poly_z_elt_delete(pring, &U1);
		U1 = tempu;
		poly_u_zm_solve_eqn(pring, q, *A, *B, S, T, U1, &Y1, &Z1);


		/*
		** Step 5 : Compute S_star, T_star
		*/
		poly_z_elt_delete(pring, &R);
		R = poly_z_integer_mult(pring,  Y1, q);

		poly_z_elt_delete(pring, &S_star);
		S_star = modpoly_subtract(pring, q_star, S, R);

		poly_z_elt_delete(pring, &R);
		R = poly_z_integer_mult(pring, Z1, q);

		poly_z_elt_delete(pring, &T_star);
		T_star = modpoly_subtract(pring, q_star, T, R);

		/*
		** Step 6 : Advance
		*/
		integer_delref(q);
		q = integer_incref(q_star);

		poly_z_elt_delete(pring, A);
		*A = m_poly_z_incref(pring, A_star);

		poly_z_elt_delete(pring, B);
		*B = m_poly_z_incref(pring, B_star);

		poly_z_elt_delete(pring, &S);
		S = m_poly_z_incref(pring, S_star);

		poly_z_elt_delete(pring, &T);
		T = m_poly_z_incref(pring, T_star);
	}

end	:
	integer_delref(q);
	poly_z_elt_delete(pring, &S);
	poly_z_elt_delete(pring, &T);
	poly_z_elt_delete(pring, &I);
	integer_delref(q_tilde);
	poly_z_elt_delete(pring, &A_tilde);
	poly_z_elt_delete(pring, &B_tilde);
	poly_z_elt_delete(pring, &S_tilde);
	poly_z_elt_delete(pring, &T_tilde);

 
		
	integer_delref(q_star);
	poly_z_elt_delete(pring, &A_star);
	poly_z_elt_delete(pring, &B_star );
	poly_z_elt_delete(pring, &R  );
	poly_z_elt_delete(pring, &R_dash  );
	poly_z_elt_delete(pring, &U );
	poly_z_elt_delete(pring, &Y );
	poly_z_elt_delete(pring, &Z );
	poly_z_elt_delete(pring, &U1 );
	poly_z_elt_delete(pring, &Y1 );
	poly_z_elt_delete(pring, &Z1 );
	poly_z_elt_delete(pring, &S_star );
	poly_z_elt_delete(pring, &T_star );

	tempa = *A;
	tempb = *B;
	*A = modpoly_hom(pring, M, tempa);
	*B = modpoly_hom(pring, M, tempb);
	poly_z_elt_delete(pring, &tempa);
	poly_z_elt_delete(pring, &tempb);
	return;
}

t_handle poly_u_zm_hensel_list WITH_5_ARGS(
t_handle,		pring,
integer_big,		p,
t_handle,		flist,
integer_big,		M,
t_poly,		C_poly
)
/* See SAC IUPQHL */
{
	t_handle	reslist;
	t_poly	C_dash, temp;
	t_poly	A_bar, B_bar, C_bar;
	t_poly	S_bar, T_bar;
	t_poly	R_poly;
	t_poly	A_poly, B_poly;
	t_int		facnum, numfacs;
	t_poly	B_monic;
	t_poly	abchk, cm, dif;

	/* Step 1 : Initialise */
	numfacs = poly_array_length(flist);
	reslist = poly_array_alloc(numfacs);

	C_dash = modpoly_hom(pring, M, C_poly);
	B_poly = m_poly_z_incref(pring, C_dash);

	A_poly = 0;
	temp = A_bar = B_bar = C_bar = 0;
	S_bar = T_bar = 0;
	R_poly =  0;

	/* Step 2 : Lift Factors. */
	facnum = 0;
	/* Make numfacs the index of the last argument. */
	numfacs--;

	while (facnum < numfacs)
	{
		A_bar = poly_array_get(flist, facnum);
		/* Not increffed */
		facnum++;

		poly_z_elt_delete(pring, &C_bar);
		C_bar = modpoly_hom(pring, p, C_dash);

		poly_z_elt_delete(pring, &B_bar);
		modpoly_quot_rem(pring, p, C_bar, A_bar, &B_bar, &temp);
		poly_z_elt_delete(pring, &temp);


		
		poly_z_elt_delete(pring, &R_poly);
		poly_z_elt_delete(pring, &S_bar);
		poly_z_elt_delete(pring, &T_bar);

		poly_u_zm_xgcd(pring, p, A_bar, B_bar, &R_poly, &S_bar, &T_bar);

		/* Since  A_poly isn't a copied we dont delete it first. */
		poly_z_elt_delete(pring, &B_poly);
		IF_DEBUG_FLAG(DEBUG_POLY,
		{
			cay_print("poly_u_zm_hensel_list : Calling poly_u_zm_hensel_lemma with ...\n");
			cay_print("p = %d\n", p);
			cay_print("M = ");
			integer_write(M);
			cay_print("\n A_bar = \n");
			poly_z_write(pring, A_bar);
			cay_print("\n B_bar = \n");
			poly_z_write(pring, B_bar);
			cay_print("\n S_bar = \n");
			poly_z_write(pring, S_bar);
			cay_print("\n T_bar = \n");
			poly_z_write(pring, T_bar);
			cay_print("\n C_dash = \n");
			poly_z_write(pring, C_dash);
		}
		)


		poly_u_zm_hensel_lemma(pring, p, A_bar, B_bar, S_bar, T_bar, M, C_dash, &A_poly, &B_poly);
		IF_DEBUG_FLAG(DEBUG_POLY,
		{
			cay_print("poly_u_zm_hensel_lemma returns ... \n");
			cay_print("A_poly = \n");
			poly_z_write(pring, A_poly);
			cay_print("B_poly = \n");
			poly_z_write(pring, B_poly);
		}
		)
#ifdef DEVELOP
		abchk = modpoly_mult(pring, M, A_poly, B_poly);
		cm = modpoly_hom(pring, M , C_dash);
		dif = modpoly_subtract(pring, M, cm, abchk);
		poly_z_elt_delete(pring, &cm);
		poly_z_elt_delete(pring, &abchk);
		ASSERT (poly_z_is_zero_poly(pring, dif));
		poly_z_elt_delete(pring, &dif);
#endif


		poly_array_append(reslist, A_poly);
		/* Not increffed */
		
		if (facnum < numfacs)
		{
			poly_z_elt_delete(pring, &R_poly);
			/* The next line is illegal since A_poly really had the reference 
			** transferred away from it in the append - but I know it is
			** still there.
			*/
			modpoly_quot_rem(pring, M, C_dash, A_poly, &temp, &R_poly);

			poly_z_elt_delete(pring, &C_dash);
			C_dash = temp;
			/* So temp is effectively deleted */
		}
	}
	/* 
	** Now the final factor of M is B_poly. Since we want 
	** the product of the polynomials to be the monic associate
	** of C mod M we divide B_poly by its leading coefficient.
	*/
	B_monic = modpoly_monic(pring, M, B_poly);
	poly_z_elt_delete(pring, &B_poly );
 	poly_array_append(reslist, B_monic);
	/* Not increffed */

	poly_z_elt_delete(pring, &C_dash);

	poly_z_elt_delete(pring, &B_bar);
	poly_z_elt_delete(pring, &C_bar);
	poly_z_elt_delete(pring, &R_poly);
	poly_z_elt_delete(pring, &S_bar);
	poly_z_elt_delete(pring, &T_bar);


	return reslist;
}

