#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"

void
poly_z_copy_term WITH_5_ARGS(
    t_handle,        pring,
    t_handle *,        ptoph,
    t_int,   totermno,
    t_handle,          fromph,
    t_int,   fromtermno
)
/*
*    IPOLY_COPY_TERM: copies a term
*    Must be passed the address of the poly
*    e.g. poly_copy_term( pring, &resph, restermno, aph, atermno )
*/
{
    t_poly    coefft;
    
    ASSERT ( totermno >= 0 && fromtermno >= 0 && fromtermno < m_poly_nterms( fromph ));

    coefft = m_poly_coefft( fromph, fromtermno );
    m_poly_coefft( *ptoph, totermno ) = m_poly_z_incref( pring, coefft );
    m_poly_expt( *ptoph, totermno ) = m_poly_expt( fromph, fromtermno );
}


t_poly
poly_z_copy_poly WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*    IPOLY_COPY_POLY: Copies one whole polynomial and returns a separate copy
*/
{
    block_declarations;
    t_handle           resph;
    t_handle           aph;
    t_int    nterms;
    t_int    termno;
    t_poly        coeff;

    if ( m_poly_const( apoly ) )
    {
        return integer_incref( apoly );
    }

    /* non-trivial polynomial */

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );
    m_poly_create_empty(&resph, m_poly_princvar( aph ),
                                    m_poly_least_pvar( aph ), nterms );

    /* copy term by term */

    for ( termno = 0; termno < nterms; termno++ )
    {
	coeff = m_poly_coefft( aph, termno );
	m_poly_coefft( resph, termno ) = m_poly_z_incref( pring, coeff );
	m_poly_expt( resph, termno ) = m_poly_expt( aph, termno );
    }

    return m_poly_handle_to_poly( resph );
}

