#include "defs.h"
#include "integer.e"
#include "poly.h"


t_poly
poly_z_shift_range  WITH_3_ARGS(
    t_handle,       pring,
    t_poly,      apoly,
    integer_big,    m
)
/*
**  apoly-a polynomial over Z_m
**  m-positive integer
**  returns the polynomial with coefficients in (-m/2,m/2)
**   congruent to apoly modulo m.
*/
{
    block_declarations;
    t_int    nterms;
    t_int    term;
    integer_big       m2;     /* m/2          */
    t_handle            aph;    /* apoly t_handle */
    t_handle            ash;    /* astar t_handle */

    m2 = integer_div (m,2);

    if (m_poly_const (apoly))
    {
        if (integer_compare (apoly, m2) > 0)
        {
            integer_delref (m2);
            return ( integer_subtract (apoly , m));
        }
        integer_delref (m2);
        return (integer_incref (apoly));
    }

    integer_delref (m2);
    aph = m_poly_poly_to_handle(apoly);
    nterms = m_poly_nterms(aph);
    m_poly_create_empty(&ash, m_poly_princvar(aph),
                                        m_poly_least_pvar (aph), nterms);

    for (term = 0; term < nterms; term ++)
    {
        m_poly_coefft(ash, term) = 
                   poly_z_shift_range (pring, m_poly_coefft(aph,term), m);
        m_poly_expt(ash, term) = m_poly_expt(aph, term);
    }

    return (m_poly_handle_to_poly (ash));
}

