#include "defs.h"
#include "poly.h"
#include "zm.e"


static t_poly poly_zm_reduce_rec P_((t_handle,integer_big,t_poly));

public t_handle
poly_zm_reduce_modulo(pring, apoly)
t_handle	pring;
t_poly	apoly;
/*
** apoly is a polynomial defined over the integers,
** reduce it modulo m.
*/
{
	t_handle	res;

	res = poly_zm_reduce_rec(pring, zm_modulus(m_poly_coeff_ring(pring)), apoly);
	if (!res) 
		return poly_z_zero_poly(pring, apoly);
	else
		return res;
}


static t_poly
poly_zm_reduce_rec(pring, modulus, apoly)
t_handle	pring;
integer_big	modulus;
t_poly	apoly;
{
	t_int		index, i, n;
	t_handle	resph, aph;
	t_poly	res, ci;

	if (m_poly_const(apoly))
		return integer_rem(apoly, modulus);

	aph = m_poly_poly_to_handle(apoly);
	n = m_poly_nterms(aph);
	m_poly_create_empty(&resph, m_poly_princvar(aph), m_poly_least_pvar(aph), n);

	for (index = 0, i = 0; i < n; i++)
	{
		ci = poly_zm_reduce_rec(pring, modulus, m_poly_coefft(aph, i));
		if (ci)
		{
			m_poly_coefft(resph, index) = ci;
			m_poly_expt(resph, index) = m_poly_expt(aph, i);
			index++;
		}
	}
	m_poly_red(resph, index); /* reduce it down to the necessary size. */
	m_poly_nterms(resph) = index;
	
	res =  m_poly_handle_to_poly(resph);
	if (!index)
	{
		poly_z_elt_delete(pring, &res);
		res = 0;
	}

	return res;
}

