#include "defs.h"
#include "integer.e"
#include "q.h"

rational
q_int_add WITH_3_ARGS(
	t_handle,		field,
	rational,	a,
	integer_big,	b
)
/*
Returns the sum of rational a and integer b.
*/
{
    block_declarations;
    rational		c;
    integer_big		numer, temp2;

    if (a == 0 && b == 0)
    {
	return 0;
    }

    if (b == 0)
    {
	return q_incref(a);
    }

    if (a == 0)
    {
	c = q_new();
	q_numer(c) = integer_incref(b);
	q_denom(c) = 1;
    }

    if (q_denom(a) == 1)
    {
	numer = integer_add(q_numer(a), b);

	if (numer == 0)
	{
	    return 0;
	}

	c = q_new();
	q_numer(c) = numer;
	q_denom(c) = 1;
    }
    else if (q_denom(a) == -1)
    {
	numer = integer_subtract(b, q_numer(a));

	if (numer == 0)
	{
	    return 0;
	}

	c = q_new();
	q_numer(c) = numer;
	q_denom(c) = 1;
    }
    else
    {
	temp2 = integer_mult(b, q_denom(a));
	numer = integer_add(q_numer(a), temp2);
	integer_delref(temp2);

	if (numer == 0)
	{
	    return 0;
	}

	c = q_new();
	q_numer(c) = numer;
	q_denom(c) = integer_incref(q_denom(a));
    }

    q_simplify(c);

    return c;
}

