
#include "defs.h"
#include "mp.e"
#include "real.e"
#include "error.e"

t_real
real_arccosech WITH_2_ARGS(
	t_handle,		r,
	t_real,		t
)
/*
** Returns arccosech( t ).
*/
{
	mp_float	tf, resf, t1, t2;

	if (glue_real_is_zero (r, t))
	{
		error_runtime (ERR_DOMAIN);
	}
	real_make_mp( t, tf );
	t1 = mp_alloc( real_base, real_beta_prec( r ));
	t2 = mp_alloc( real_base, real_beta_prec( r ));
	resf = mp_alloc( real_base, real_beta_prec( r ));

	mp_rec( tf, t2 );
	mp_mul( t2, t2, t1 );
	mp_add_int( t1, 1, t1 );
	mp_sqrt( t1, t1 );
	mp_add( t1, t2, t1 );
	mp_log( t1, resf );

	mp_delete_float( t1 );
	mp_delete_float( t2 );

	return mp_to_real( resf );
}
