#include "defs.h"
#include "real.e"
#include "error.e"
#include "structure.e"
#include "integer.e"
#include "globals.e"
#include "ring.e"
#ifndef KANT
#include "alg.e"
#endif

static t_logical real_str_create_arg P_((t_int,t_int,t_int));
static t_handle real_str_create_hard P_((t_int));

private t_logical real_str_create_arg( n, p1, p2 )
t_int n;
integer_big p1, p2;
{
	switch( n )
	{
		case 0:
			return p1 == p2;
			break;
		default:
			DIE();
	}
	return FALSE;
}

/*
** create field of reals of precision prec, new copy if copy == TRUE
*/

private t_handle real_str_create_hard( prec )
t_int prec;
{
	t_handle	r;

	r = structure_alloc( sizeof(t_real_table), 0, 1, REP_REAL, FALSE);
	ring_put_type( r, RING_R);

	ring_set_is_field_true(r);

	real_dec_prec( r ) = prec;
	real_beta_prec( r ) = real_beta_digits( prec );

	return r;
}

public t_handle real_str_create( prec )
t_int prec;
{
	if( prec <= 0 )
	{
		error_runtime( ERR_ARG_LT_INT, 1, prec, 1);
	}

#ifndef KANT
	return structure_create( REP_REAL, 
		real_str_create_hard, real_str_create_arg, 1, prec );
#else /* KANT */
	return real_str_create_hard(prec);
#endif /* KANT */

}
