#include "kant.h"
#include "thue.h" 

t_logical
thue_norm_equation WITH_1_ARG(
                thue,           th
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	t_handle	R;
        t_int           M, i, i_max;
        order           ord;
        dyn_arr_handle  gamma;
        anf_elt         dummy;
        t_logical       solve;


        ord = thue_order(th);
        R = thue_reals(th);

        M = integer_abs(thue_M(th) );

        if (integer_compare(M, 1) == 0)
                {
                gamma = dyn_arr_alloc(1);
                dyn_arr_element(gamma, 0) = 1;
                dyn_arr_curr_length(gamma) = 1;
                solve = TRUE;
                }
        else
                {
                if (thue_print_level(th)>=2)
                        printf("Solving norm equation...\n");

        	gamma = MEM_NH;
        	order_norm_equation(ord, M, &dummy, &gamma, TRUE);

        	if (gamma != MEM_NH)
                	{
                        if (thue_print_level(th) >=2)
                                {
                                printf("Elements with Norm "); integer_write(M); puts("");
        			i_max = dyn_arr_curr_length(gamma);
        			for (i=0; i<i_max; i++)
                			{
                			printf("gamma%d = ",i+1);
                			anf_elt_write(ord, dyn_arr_element(gamma, i) );
                			puts("");
                			}
                                puts("");
                                }
                        solve = TRUE;
                	}
        	else
                	{
                	printf("No elements with norm "); integer_write(M); puts("");
                        solve = FALSE;
                	}
                }
        integer_delete(&M);
        thue_gamma(th) = gamma;

        return solve;
}
