  
*
*DOC  INCLUDE-FILE (DEBUG TOOLS)
*
*                 Einfuehrung von  FIELD7       JS 07.06.88
*                 FINIR4                        JS 22.07.88
*                 JOBNAM                        JS 17.10.88
*                 FINIR4 verbessert             JS 31.01.89
*                 RIEHYP implemented            JS 01.07.89
*                 English documentation         JS 25.07.89
*                 ERRMSG                     MJ/JS 14.08.89
*                 FLEDIM/FLENRS in FIELD4       JS 23.08.89
*                 TIMSET, TIMBND and TIMSTT     JS 08.02.90
*                 PI                         MJ/JS 15.02.90
*                 LZRFLG,SHLFLG                 JS 07.03.91
*                 TSTFL2,TSTFL1,TSTSUB          JS 12.06.91
*
************************************************************************
*  Part 1: Declarations
************************************************************************
*
*     MAXDIM: maximal possible field degree
*     RADIX : Logarithm of base 2 of MAXINT+1
*     MAXMAT: maximal dimension of scratch arrays in subroutines
*
      INTEGER MAXDIM,MAXMAT,RADIX
      PARAMETER (MAXDIM=20,MAXMAT=50,RADIX=32)
*
*     MAXINT: maximal possible INTEGER*4 (usually 2**31-1)
*     EPS   : Values below EPS are treated as zero
*     LOGEPS: natural logarithm of EPS
*     MAXDP : maximal (as REAL*8) exact representable integer
*     FINITY: maximal representable DP-number
*     FINIR4: maximal representable  REAL*4-number
*     PI    : pi
*
      REAL FINIR4
      DOUBLE PRECISION MAXINT,EPS,MAXDP,FINITY,LOGEPS,RNLGRX,PI
      PARAMETER (MAXINT=2147483647.0D0,MAXDP=1.0D14,EPS=1.0D-14)
      PARAMETER (LOGEPS=-0.3223619D+02,FINITY=0.7237D+76)
      PARAMETER (FINIR4=0.99999E+38)
      PARAMETER (PI=3.14159265358979)
*
*
*     IER   : error parameter, =0 if everything OK, else <>0
*     DNRIER: file number for error outputs
*     DNRINP: file number for standard input
*     DNROUT: file number for standard output
*     INIFLG: controlling flag for output of initialized values
*     TSTFLG: controlling flag for output of intermediate data
*     TSTFL1: primary TSTFLG
*     TSTFL2: alternative TSTFLG (for name list of TSTSUB)
*     RIEHYP: =0 (default if GRH is not assumed, else: 1)
*     OUTFLG: =1 ((Output in COMOUT)
*     PRECIS: =10 for long computation of the zeroes LROOTF and LRITB
*                (default, else: 0)
*
      INTEGER IER,DNRIER,DNRINP,DNROUT,INIFLG,TSTFLG,RIEHYP,OUTFLG
      INTEGER PRECIS,TSTFL2,TSTFL1
*
*     TIMSET: if > 0: time limitation controlling is active
*               else: controlling deactivated
*     TIMBND: Bound for time controlling
*     TIMSTT: Start of controlling
*     LZRFLG: Flag for long zeroes
*
      INTEGER TIMSET, LZRFLG
      DOUBLE PRECISION TIMBND, TIMSTT
*
*     parameters only for internal use:
*
*     LVLPTR: zeigt die aktuelle Verschachtelungsebene an
*     ERRFLG: =1, falls gerade eine Fehlermeldung ausgegeben wurde, sonst 0
*     DLEVEL: Debug-Level fuer Unterprogrammstatistik u.a.
*     ENDLUT: aktuelle Anzahl der in SUBLUT gespeicherten Unterprogrammnamen
*     SUBPTR: zeigt auf den aktuellen Unterprogrammnamen
*     SUBCNT: zaehlt die Anzahl der Aufrufe der Unterprogramme
*
      INTEGER LVLPTR,ERRFLG,DLEVEL,ENDLUT,SUBPTR,SUBCNT(200)
*
*     SUBTIM: akkumuliert die Rechenzeit der einzelnen Unterprogramme
*     SUBTI1: Hilfsfeld fuer Aufrufzeitstatistik
*
      DOUBLE PRECISION SUBTIM(200),SUBTI1(100)
*
*     SUBNAM: beinhaltet die aktuelle Verschachtelung
*     SUBLUT: Look-Up-Table mit Unterprogrammnamen
*
      CHARACTER*6 SUBNAM(100),SUBLUT(200)
*
*     FLEDIM: maximal number of possible scratch files
*     FLENRS: scratch file organisation array
*     SHLFLG: >0: Programs are called by Kant-Shell
*
      INTEGER FLEDIM, FLENRS(2,20)      
      INTEGER SHLFLG
*
*     PRMFLE: name of prime number file
*     FILExx: Names of other files
*     JOBNAM: Name of Job                     
*     ERRMSG: actual error message
*     TSTSUB: List of subroutine names to be tested with TSTFL2
*
      CHARACTER*60 PRMFLE,FILE01,FILE02,FILE03,JOBNAM
      CHARACTER*120 ERRMSG,TSTSUB
*
************************************************************************
*  Teil 2: COMMON-Vereinbarungen                                       *
************************************************************************
*
*                     DEBUGGING tools
*
      COMMON /FIELD4/ IER,DNRIER,LVLPTR,ERRFLG,DLEVEL,ENDLUT,SUBPTR,
     *                SUBCNT,SUBTIM,SUBTI1,DNRINP,DNROUT,INIFLG,TSTFLG,
     *                RIEHYP,OUTFLG,FLEDIM,FLENRS,PRECIS,
     *                TIMSET,TIMBND,TIMSTT,LZRFLG,SHLFLG,
     *                TSTFL1,TSTFL2
*
*
*
      COMMON /FIELD5/ SUBNAM,SUBLUT
*
*                     file & job names & error message
*
      COMMON /FIELD7/ PRMFLE, FILE01, FILE02, FILE03, JOBNAM, ERRMSG,
     *                TSTSUB
*
*END
