      SUBROUTINE IERDEL()
*
C     ******************************************************************
C     *                                                                *
C     *                    S U B R O U T I N E                         *
C     *                                                                *
C     *                        I E R D E L                             *
C     *                                                                *
C     ******************************************************************
C
C
*DOC             Sets back (deletes) all error parameters
**DOC
*INDEX  IERDEL(IN/1): Event handling: sets back Error parameters
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       If an error occurs in a subroutine which leads to RETURN 1
**DOC       ("Spin-off"), IER is set to a nonzero value. If this error
**DOC       is not crucial for the calling program, i.e. if you want to
**DOC       set IER back to zero, additional internal parameters have to
**DOC       be "normed" again. This is what this routine does:
**DOC             IER    <-- 0
**DOC             ERRFLG <-- 0 
**DOC             ERRMSG <-- ' (no error text)' 
**DOC       So don't say IER=0, instead of this CALL IERDEL()!
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       -
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       -
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       IER    = 0
**DOC       ERRFLG = 0
**DOC       ERRMSG = ' (no error text)'
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       -
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       FIELD
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       17.08.89
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       -        -
**DOC
%include 'debug.inc'
*
      IER    = 0
      ERRFLG = 0
      ERRMSG = ' (no error text)'
*
      RETURN
      END
