#ifndef _PLATFORM_DUMMIES_
#define _PLATFORM_DUMMIES_

#ifdef KANT


#define STRUCTURE_FLAG_STORED   0x01                                      
#define STRUCTURE_FLAG_FINITE   0x02
#define STRUCTURE_FLAG_EXPLICIT 0x04

#define m_structure_access(s)                    ((t_structure_hdr*)mem_access(s))

#define m_structure_level(s)            (m_structure_access(s)->level)
#define m_structure_parent(s)           (m_structure_access(s)->parent)
#define m_structure_repnum(s)           (m_structure_access(s)->repnum)
#define m_structure_algs(s)                     (m_structure_access(s)->algs)
         
#define m_structure_put_level(s,l)              (m_structure_level(s)=(l));
#define m_structure_put_parent(s,p)             (m_structure_parent(s)=(p));
#define m_structure_put_repnum(s,n)             (m_structure_repnum(s) = (n));
 

#define m_structure_set_stored(s) (m_structure_access(s)->flags |= \
                                        STRUCTURE_FLAG_STORED)
#define m_structure_clear_stored(s) (m_structure_access(s)->flags &= \
                                        ~STRUCTURE_FLAG_STORED)
#define m_structure_is_stored(s) (m_structure_access(s)->flags & \
                                        STRUCTURE_FLAG_STORED)
 
#define m_structure_set_finite(s) (m_structure_access(s)->flags |= \
                                        STRUCTURE_FLAG_FINITE)
#define m_structure_clear_finite(s) (m_structure_access(s)->flags &= \
                                        ~STRUCTURE_FLAG_FINITE)
#define m_structure_is_finite(s) (m_structure_access(s)->flags & \
                                        STRUCTURE_FLAG_FINITE)
#define m_structure_set_implicit(s) (m_structure_access(s)->flags &= \
					~STRUCTURE_FLAG_EXPLICIT)
 

#define structure_parent_delete(r)	
#define structure_remove(r)

enum
{
	REP_Z = 1,
	REP_ZM,
	REP_Q,
	REP_REAL,
	REP_COMP,
	REP_POLY,
	REP_POLY_Z,
	REP_POLY_ZM,
	REP_ORDER,
	REP_ANF,
	REP_PRINCIPAL_IDEAL
};




#endif /* KANT */
#endif /* _PLATFORM_DUMMIES_ */
