
#ifndef _REAL_E_
#define  _REAL_E_


#include "integer.e"
#include "ring.h"
#include "mp.e"

/*
** Structure of a block containing a real field.
*/

typedef struct
	{
		t_ring_common	ring_hdr;

		integer_small	rg_real_beta_prec;
		integer_small	rg_real_dec_prec;
	}
	t_real_table;

/*
** Access to the information about a real field.
*/

#define real_access(h)		((t_real_table *) ring_access(h))

#define real_beta_prec(h)	(real_access(h) -> rg_real_beta_prec)
#define real_dec_prec(h)	(real_access(h) -> rg_real_dec_prec)

/*
 *	Macros to incref and delete real fields.
 */

#define m_real_str_incref(r)	(block_incref(r))
#define m_real_str_delete(r)	(real_str_delete(0,&r))

/*
** Type of a real number.
*/

#if 0
typedef t_handle t_real;
#endif

/*
** Convert real t_handle to mp float struct and vice-versa.
*/

#if 0
#define real_make_mp(x, y) \
	(y.mp_flt_handle = (x), y.mp_flt_offset = TRBL_HDR_LEN)

#define mp_to_real(f)	((f).mp_flt_handle)
#endif

#define real_make_mp(x, y) 	((y) = (x))
#define mp_to_real(f)		(f)

/*
** Define real base type.
*/

extern mp_base_type real_base;

/*
** Define an error routine for real package.
*/

#define real_error error_internal

/*
** Decrement the reference count of a real.
*/

#define real_delete( ph ) \
		( block_decref_delete( *(ph) ), *(ph) = MEM_NH )

/*
** Increment the reference count of a real.
*/

#define real_incref( h ) \
		( block_incref( h ), h )


extern Logical real_inside_bounds P_((t_handle,t_real,t_real,Logical,t_real,Logical));
extern mp_length real_beta_digits P_((t_int));
extern t_bool real_elt_coerce P_((t_handle,t_handle,t_handle,t_int,t_handle*,t_int*,t_logical));
extern t_handle glue_real_add P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle glue_real_inverse P_((t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_real_is_minus_one P_((t_handle,t_handle));
extern t_handle glue_real_is_one P_((t_handle,t_handle));
extern t_handle glue_real_is_zero P_((t_handle,t_handle));
extern t_handle glue_real_log P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_real_mult P_((t_handle,integer_big,t_int,integer_big,t_int,integer_big*,t_int *));
extern t_handle glue_real_negate P_((t_handle,t_handle,t_handle *));
extern t_handle glue_real_norm P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle glue_real_power P_((t_handle,t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));
extern t_handle glue_real_slash P_((t_handle,t_handle,t_handle));
extern t_handle glue_real_subtract P_((t_handle,t_handle,t_handle,t_handle *));
extern t_handle real_str_create P_((t_int));
extern t_handle real_str_incref P_((t_handle,t_handle));
extern t_int real_compare P_((t_handle,t_real,t_real));
extern t_int real_elt_precision P_((t_handle,t_handle));
extern t_int real_seq_max P_((t_handle,t_handle));
extern t_int real_seq_min P_((t_handle,t_handle));
extern t_int real_sign P_((t_handle,t_real));
extern t_int real_str_precision P_((t_handle,t_handle));
extern t_logical glue_real_eq P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_logical glue_real_ge P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int,t_handle *));
extern t_logical glue_real_gt P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_logical glue_real_le P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int,t_handle *));
extern t_logical glue_real_lt P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int,t_handle *));
extern t_logical real_eq P_((t_handle,t_handle,t_handle));
extern t_logical real_ge P_((t_handle,t_real,t_real));
extern t_logical real_gt P_((t_handle,t_real,t_real));
extern t_logical real_is_probability P_((t_handle,t_real));
extern t_logical real_le P_((t_handle,t_real,t_real));
extern t_logical real_lt P_((t_handle,t_real,t_real));
extern t_logical real_ne P_((t_handle,t_real,t_real));
extern t_real a_to_real P_((t_handle,t_char *));
extern t_real real_abs P_((t_handle,t_real));
extern t_real real_add P_((t_handle,t_real,t_real));
extern t_real real_arccos P_((t_handle,t_real));
extern t_real real_arccosec P_((t_handle,t_real));
extern t_real real_arccosech P_((t_handle,t_real));
extern t_real real_arccosh P_((t_handle,t_real));
extern t_real real_arccot P_((t_handle,t_real));
extern t_real real_arccoth P_((t_handle,t_real));
extern t_real real_arcsec P_((t_handle,t_real));
extern t_real real_arcsech P_((t_handle,t_real));
extern t_real real_arcsin P_((t_handle,t_real));
extern t_real real_arcsinh P_((t_handle,t_real));
extern t_real real_arctan P_((t_handle,t_real));
extern t_real real_arctan2 P_((t_handle,t_real,t_real));
extern t_real real_arctanh P_((t_handle,t_real));
extern t_real real_besj P_((t_handle,t_real,t_int));
extern t_real real_catalan P_((t_handle));
extern t_real real_cos P_((t_handle,t_real));
extern t_real real_cosec P_((t_handle,t_real));
extern t_real real_cosech P_((t_handle,t_real));
extern t_real real_cosh P_((t_handle,t_real));
extern t_real real_cot P_((t_handle,t_real));
extern t_real real_coth P_((t_handle,t_real));
extern t_real real_daw P_((t_handle,t_real));
extern t_real real_divide P_((t_handle,t_real,t_real));
extern t_real real_ei P_((t_handle,t_real));
extern t_real real_elt_incref P_((t_handle,t_real));
extern t_real real_erf P_((t_handle,t_real));
extern t_real real_erfc P_((t_handle,t_real));
extern t_real real_euler P_((t_handle,t_handle));
extern t_real real_exp P_((t_handle,t_real));
extern t_real real_gamma P_((t_handle,t_real));
extern t_real real_inverse P_((t_handle,t_real));
extern t_real real_li P_((t_handle,t_real));
extern t_real real_log P_((t_handle,t_real));
extern t_real real_log_gamma P_((t_handle,t_real));
extern t_real real_logb P_((t_handle,t_real,t_real));
extern t_real real_make P_((t_handle,integer_big,t_int));
extern t_real real_max P_((t_handle,t_real,t_real));
extern t_real real_min P_((t_handle,t_real,t_real));
extern t_real real_mult P_((t_handle,t_real,t_real));
extern t_real real_negate P_((t_handle,t_real));
extern t_real real_pi P_((t_handle));
extern t_real real_power P_((t_handle,t_real,t_int));
extern t_real real_real_power P_((t_handle,t_real,t_real));
extern t_real real_root P_((t_handle,t_real,t_int));
extern t_real real_sec P_((t_handle,t_real));
extern t_real real_sech P_((t_handle,t_real));
extern t_real real_sin P_((t_handle,t_real));
extern t_real real_sinh P_((t_handle,t_real));
extern t_real real_sqrt P_((t_handle,t_real));
extern t_real real_subtract P_((t_handle,t_real,t_real));
extern t_real real_tan P_((t_handle,t_real));
extern t_real real_tanh P_((t_handle,t_real));
extern t_real real_truncate P_((t_handle,t_real));
extern t_real real_zeta P_((t_handle,t_int));
extern t_void real_elt_delete P_((t_handle,t_real *));
extern t_void real_elt_print P_((t_handle,integer_big));
extern t_void real_str_delete P_((t_handle,t_handle *));
extern t_void real_str_print P_((t_handle,t_handle));
extern void real_start P_((mp_round_type,void_func));
extern void real_write P_((t_handle,t_real,t_int));

#endif /* _REAL_E_ */

