/******************************************************************************
  anf_elt_is_integer_sub.c
******************************************************************************/

#include "kant.h"
#include "z.e"
#include "integer.e"
#include "anf.h"

t_logical
anf_elt_is_integer_sub WITH_3_ARGS(
	order,		ord,
	anf_elt,	alpha,
	integer_big*,	alpha_int
)
/*******************************************************************************
 
Description:
 
	Tests, whether an algebraic number is an integer
 
Calling sequence:
 
	boole = anf_elt_simplify(ord,alpha,alpha_int);
 
      	order         ord       = t_handle of order 
	anf_elt	      alpha     = algebraic number 
	integer_big*  alpha_int = pointer to a t_handle of an integer_big
      	t_logical       boole     = TRUE  if alpha is an integer
		                  FALSE else
 
History:
 
	91-12-18 KW    written
 
*******************************************************************************/
{
	block_declarations;

	integer_big     den;
	integer_big     q,r;
	integer_big     temp;
	integer_small   deg;
	integer_small   i,j;
	order		ordcoef;

	den = 1;

        while(!anf_elt_is_integer(alpha))  
	{
		j = order_one_position(ord);

		if (!j)
		{
			integer_delref(den);
			return(FALSE);
		}
                    
		deg = order_rel_degree(ord);

		ord = order_coef_order(ord);

		for(i=1;i<=deg;i++)
		{
			if (i != j)
			{                        	
				if (!anf_elt_is_zero(ord,anf_elt_coef(alpha,i)))
				{
					integer_delref(den);
					return(FALSE);
				}
 			}
 		}

		temp = den;
                den = integer_mult(anf_elt_den(alpha),temp);
		integer_delref(temp);

                alpha = anf_elt_coef(alpha,j);
	}

	integer_quot_rem(alpha,den,&q,&r);

	if (r != 0)
	{
		integer_delref(den);
		integer_delref(q);
		integer_delref(r);
		return(FALSE);
	}

	*alpha_int = q;

	integer_delref(den);
	integer_delref(r);
	return(TRUE);
}
		
