/******************************************************************************
  anf_elt_to_princ_ideal.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "anf.h"

anf_ideal
anf_elt_to_princ_ideal WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:
                                                                   
	Creates a principal ideal with generator alpha.
	The ideal will be given in 2-Element-Presentation.
  
Calling sequence:
 
        anf_elt_to_princ_ideal(ord, alpha);
 
        order   	ord:    order over which new ideal shall be defined
        anf_elt       alpha:    generator of new principal ideal
 
History:

	92-06-11 CO     first version

*******************************************************************************/
{       
	block_declarations;
 
	return anf_ideal_2_create( ord, alpha, alpha );
}
