/******************************************************************************
  anf_ideal_anf_elt_div.c
******************************************************************************/
 
#include "kant.h"

anf_ideal
anf_ideal_anf_elt_div WITH_3_ARGS(
	order,		ord,
        anf_ideal,      id,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description: 
 
 	Divides an ideal by an algebraic number.
        Every element of the ideal basis is multiplied by the inverse of alpha.
        The result is simplified.
               
 
Calling sequence: 
	
	idnew = anf_ideal_anf_elt_div(ord, id, alpha);
                               
	order		ord    = t_handle of the order
        anf_ideal       id     = t_handle of ideal (numerator)
        anf_elt         alpha  = algebraic number (denominator)

  
History:

 	92-03-01 MJ 	first version
 
*******************************************************************************/
{       
	block_declarations;  

        order           ordcoef;
        anf_ideal       id1;  
        anf_elt         ainv, beta,beta1,gamma;
        integer_small   j,i,n; 
        integer_big     den1,temp,temp1, trden;
        matrix          trans,trans1,trans2;  
        vector          denom;
        
	order_must_be_over_z(ord);
 
	if(!anf_ideal_is_z(id)) anf_ideal_2_z(ord, id);
 
        ordcoef = order_coef_order(ord);
        den1   = 1; 
        n      = order_abs_degree(ord); 
	trans  = anf_ideal_tran(id);  
        trden  = anf_ideal_tran_den(id);
 
        trans1 = mat_new(n,n);
        denom  = vec_new(n);
 
        ainv   = anf_inverse(ord, alpha);

        for ( i=1 ; i<=n ; i++ )
        {
           beta              = mat_order_col_to_anf_elt(ord,trans,i);
           anf_elt_den(beta) = integer_incref(trden);
           gamma             = anf_mult(ord,ainv,beta);   

           if ( anf_print_level  > 5 ) 
                  {
                            printf("Division of ideal by alpha: ");
                            anf_elt_write(ord,beta); 
                            printf("   /   ");
                            anf_elt_write(ord,alpha); 
                            printf("   =   ");
                            anf_elt_write(ord,gamma); 
                            printf("\n"); 
                  }  
 
           temp               = den1; 
           temp1              = anf_elt_den(gamma);
           den1               = integer_lcm(temp,temp1);
 
           vec_entry(denom,i) = integer_incref(anf_elt_den(gamma));
 
           anf_elt_to_mat_order_col(ord,gamma,trans1,i);
 
           integer_delref(temp);
           anf_elt_delete(ord, &beta);
           anf_elt_delete(ord, &gamma);
        }   
 
        trans2 = mat_new(n,n);

        for ( i=1 ; i<=n ; i++ )
        {
           beta              = mat_order_col_to_anf_elt(ord,trans1,i);
           anf_elt_den(beta) = integer_incref(vec_entry(denom,i)); 
           beta1             = anf_elt_mult(ord,den1,beta);
 
           if ( anf_print_level > 5 )
                  {
                            printf("Trafomatrix(i) * lcm: ");
                            anf_elt_write(ord,beta);
                            printf("  *  ");
                            integer_write(den1);
                            printf("  =  ");
                            anf_elt_write(ord,beta1);    
                            printf("\n");   
                  }
                  /* Feel free, simplify it */
           gamma = anf_elt_simplify(ord,beta1);
           anf_elt_to_mat_order_col(ord,gamma,trans2,i); 
 
           anf_elt_delete(ord, &beta);
           anf_elt_delete(ord, &beta1);
           anf_elt_delete(ord, &gamma);
        }                                           
 
        mat_delref(ordcoef, &trans1);
        vec_delete(ordcoef, &denom);
        anf_elt_delete(ord, &ainv);
 
        if ( anf_print_level > 3 )
           {      
                   printf("Trafomatrix before Hermite reduction:\n");  
                   mat_ring_write(ordcoef,trans2);
                   printf("\n"); 
           }  


        trans1 = mat_ring_hnf_col_upper (ordcoef,trans2);  /* hermite reduction */
        if ( anf_print_level > 3 )
           {
                   printf(" Trafomatrix after Hermit-reduction:\n");
                   mat_ring_write(ordcoef,trans1);
                   printf("\n");
           }                
 
        mat_delref(ordcoef,&trans2);
 
        mat_z_simplify(ordcoef, trans1, &den1);
 
        if ( anf_print_level > 3 )
           {
                   printf(" Matrix divided by ggt:\n");
                   mat_ring_write(ordcoef,trans1);
                   printf("\n");
           }  


        id1 = anf_ideal_z_create(ord,trans1,den1);  
	anf_ideal_tran_hnf(id1) = 1; 
 
        if ( anf_print_level > 5 )
           {
                   printf(" Resulting ideal:\n");
                   anf_ideal_z_write(ord,id1); 
                   printf("\n"); 
           }

        /* Kill the bytes!!! */
        
        mat_delref(ordcoef,&trans1);
                                               
        return id1;
} 
