/******************************************************************************
  anf_ideal_take_out_of_faclst.c
******************************************************************************/
 
#include "kant.h"        

t_void
anf_ideal_take_out_of_faclst WITH_3_ARGS(
	t_handle *,	lst,
	order,		ord,
	integer_small,	i
)
/*******************************************************************************
 
Description:
                                     
	Throws away the i-th entry of the ideal factor list lst.
	(This means i must be less than m_poly_z_faclst_len(..) !)
	If the faclst is empty after this, it will be deleted.

  
Calling sequence:
 
        anf_ideal_min_assure(ord, id);
 
	t_handle *	lst:    list of ideals
        order   	ord:    order over which ideals are defined
        integer_small   i:    	number of ideal being deleted

 
History:

	92-07-17 CO     first version

*******************************************************************************/
{
        block_declarations;

        integer_small     len;  


	len = m_poly_z_faclst_len( *lst );
	if( len == 1 )
		anf_ideal_faclst_delete( ord, lst );
	else
	{
		if( i >= len )
			error_internal("take_ideal_out_of_faclst: i is too big.");

		anf_ideal_delete( ord, &m_poly_z_faclst_factor( *lst, i ) );

		for( ; i < len-1 ; i++ )
		{
			m_poly_z_faclst_factor( *lst, i ) = m_poly_z_faclst_factor( *lst, i+1 );
			m_poly_z_faclst_power( *lst, i ) = m_poly_z_faclst_power( *lst,i+1 );
		}

		m_poly_z_faclst_len_put( *lst, len-1 );
	}
}
