/*******************************************************************************
  fincke.c 
    H
    fincke_func
********************************************************************************/

           
 
#include "kant.h"



t_real 
H     WITH_3_ARGS    (t_handle    , R  ,
                      t_real    , x  ,
                      t_real    , one )
/*******************************************************************************

Description:
                                    
   Subfunction h : ]1,oo[ --> R as defined in Fincke p.53                      
   The function will return h(x).
                

Calling sequence:                                       

       t_handle    R     : A real field
                          
       t_real    x     : The value of h in x will be computed.
       t_real    one   : This function ( H () ) is just a subfunction of 
                         fincke_func (). There 1 (R) is already computed.

       t_real    h     : The return value.
                                          

     h = H (R,x,one);
                                                           
                            
History:                                 

    09.06.92     MD    first version

********************************************************************************/
{


             t_real     temp1,temp2;
             t_real     x_log;



   temp1 = real_log (R,x);
   x_log = real_divide (R,one,temp1);

   real_delete (&temp1);

   
   temp1 = real_subtract (R,x,one);
   temp2 = real_divide (R,x,temp1);
   
   real_delete (&temp1);
   
   temp1 = real_subtract (R,temp2,x_log);
   
   real_delete (&temp2);
   real_delete (&x_log);


   return temp1;

}




t_real
fincke_func WITH_4_ARGS (t_handle     ,  R     ,
                         t_real     ,  x     ,
                         t_real     ,  param1,
                         t_real     ,  param2 )

/*******************************************************************************

Description:
                                                             
     Computes the value of the function desc. in Fincke p 53.
     The function dependes on two additional parameters (param1 and param2). 


Calling sequence:                                           

       t_handle    R      : A real field
       t_real    x      : The value of h in x will be computed.
       
       t_real    param1 : the first of the two parameters.
       t_real    param2 : the second one. 
                                         

       t_real    f      : the return value


    f = fincke_func (R,x,param1,param2);       
                            
History:                                 

    09.06.92     MD    first version

********************************************************************************/
{
            t_real    one,h;
            t_real    temp1,temp2,temp3;
            t_real    p1,p2,p3;
 
                  
                
  one = conv_double_to_real (R,1.0); 
  h   = H (R,x,one);

  temp1 = real_subtract (R,one,h);    
  temp2 = real_real_power (R,x,h);

  temp3 = real_divide  (R,temp2,x);
  
  p1 = real_mult (R,temp1,temp2);


  real_delete (&temp1);
  real_delete (&temp2); 
                               
  p2 = real_mult (R,h,temp3);
  
  real_delete (&temp3);


  temp1 = real_add (R,one,param1);

  p3 = real_real_power (R,temp1,param2);

  real_delete (&temp1);

  
  temp1 = real_add (R,p1,p2);
  temp2 = real_subtract (R,temp1,p3);
 
  real_delete (&temp1);

  real_delete (&p1);
  real_delete (&p2);
  real_delete (&p3);

  real_delete (&one);
  real_delete (&h);
      

  return temp2;

}
