#include "kant.h"
#include "mat.h"
#include "z.e"
#include "poly.h"
#include "vector.h"        
#include "integer.e"

integer_big
ipoly_disc WITH_3_ARGS( 
	t_poly,	pol,
	integer_small*,	r1,
	integer_small*,	r2	
                      )
/*********************************************************************************

Description:  

	Computes the discriminant and the signature of a polynomial
        Signature is computed only for separable polynomials!
        
        See: A. Schwarz, ``Berechnung von Zahlk\"orpern f\"unften
             Grades mit kleiner Diskriminante'', Diplomarbeit, 
             Heinrich-Heine-Universit\"at D\"usseldorf 1991, p. 31.

Calling sequence: 

	d = ipoly_disc(p, &r1, &r2);

	t_poly	p	=	polynomial
	integer_small	r1      =	signature
	integer_small	r2	=	(n-r1) / 2

	integer_big	d	=	discriminat
	
History:

*********************************************************************************/
{
 	block_declarations;

        integer_small		i, j, k, l, nterms, n, exponent; 
	matrix			m;
        t_handle			Z, hpol;
	vector			a, S;
	integer_big		old, old1, old2, old3, den;
        t_logical			pivot;    

	Z = m_z_str_incref(structure_z);

        hpol =  m_poly_poly_to_handle(pol);
	nterms = m_poly_nterms(hpol);
	n = m_poly_expt(hpol, nterms-1); 
	if (n == 1)
		{
		*r1 = 1;
		*r2 = 0;
		return 1;
		} 
	a = vec_new(n);
	S = vec_new(n+n-2);
	for (i=1; i<=n; i++)
		vec_entry(a, i) = 0;
	for (i=0; i<nterms; ++i)
		{ 
		exponent = m_poly_expt(hpol, i); 
		old = vec_entry(a, n-exponent);
		vec_entry(a, n-exponent) = integer_incref(m_poly_coefft(hpol, i) ); 
		integer_delref(old);
		} 
	for (k=1; k<=n; k++)
		{
		vec_entry(S, k) = 0;
		for(i=1; i<=k-1; i++)
			{ 
			old = vec_entry(S, k);
			old1 = integer_mult(vec_entry(a, i), vec_entry(S, k-i) );
                        vec_entry(S, k) = integer_subtract(vec_entry(S, k), old1 ); 
			integer_delref(old); 
			integer_delref(old1);
			}
		old = vec_entry(S, k); 
		old1 = integer_mult(k, vec_entry(a, k) );
		vec_entry(S, k) = integer_subtract(vec_entry(S, k), old1 );
		integer_delref(old);
		integer_delref(old1);
		}
	for(k=n+1; k<=n+n-2; k++)
		{
		vec_entry(S, k) = 0; 
 		for(i=1; i<=n; i++)
			{
			old = vec_entry(S, k);
			old1 = integer_mult(vec_entry(a, i), vec_entry(S, k-i) );
                        vec_entry(S, k) = integer_subtract(vec_entry(S, k), old1 );
			integer_delref(old);
			integer_delref(old1);
			}
		} 
	m = mat_new(n ,n);
        for (i=1; i<=n; i++)
		for (j=1; j<=n; j++)
			if (i==1 && j==1)
				{
				mat_elt(m, i, j) = n;
				}
			else
				{
				mat_elt(m, i, j) = integer_incref(vec_entry(S, i+j-2) );
	                        } 
	vec_delete(Z, &S);
	vec_delete(Z, &a);
	*r1 = 0;
	den = 1;
	for(k=1; k<=n-1; k++)
		{
		pivot = FALSE;		
                if (mat_elt(m, k, k) == 0 )
			{
			l=k+1;
			while ((l < n) && (mat_elt(m, l, l) == 0))  {++l;}
          		if (mat_elt(m, l, l) != 0)
          			{ 
          			for (i=k; i<=n; i++)
          				{
          				old = mat_elt(m, k, i);
          				mat_elt(m, k, i) = integer_incref(mat_elt(m, l, i) );
          				integer_delref(mat_elt(m, l, i));
					mat_elt(m, l, i) = integer_incref(old );
					integer_delref(old);
					}
				for (i=k; i<=n; i++)
                                        {
          				old = mat_elt(m, i, k);
          				mat_elt(m, i, k) = integer_incref(mat_elt(m, i, l) );
          				integer_delref(mat_elt(m, i, l));
					mat_elt(m, i, l) = integer_incref(old );
					integer_delref(old);
          				} 
				pivot = TRUE;
          			}
			if (!pivot)
				{ 
				l=k+1;
				while ((l < n) && (mat_elt(m, k, l) == 0))  {++l;}
          			if (mat_elt(m, k, l) != 0)
          				{ 
          				for (i=k; i<=n; i++)
          					{
          					old = mat_elt(m, k, i);
          					mat_elt(m, k, i) = integer_add(mat_elt(m, k, i), mat_elt(m, l, i) );
						integer_delref(old);
						}
					for (i=k; i<=n; i++)
                                                {
          					old = mat_elt(m, i, k);
          					mat_elt(m, i, k) = integer_add(mat_elt(m, i, k), mat_elt(m, i, l) );
						integer_delref(old);
          					} 
					pivot = TRUE;
          				}
				}
			if (!pivot)
				{
				mat_delref(Z, &m);
				*r1 = -1;
				*r2 = -1;
				return 0;
				}
			}
		for (i=k+1; i<=n; i++) 
			for (j=i; j<=n; j++)
				{
				old = mat_elt(m, i, j);
				old1 = integer_mult(mat_elt(m, k, k), mat_elt(m, i, j));
				old2 = integer_mult(mat_elt(m, i, k), mat_elt(m, k, j));
				old3 = integer_subtract(old1, old2);
				mat_elt(m, i, j) = integer_div(old3, den);
				integer_delref(old);
				integer_delref(old1);
				integer_delref(old2);
				integer_delref(old3);
				}
		for (i=k+1; i<=n; i++)
			{
			integer_delref(mat_elt(m, k, i) );
			mat_elt(m, k, i) = 0;
			}
		for (i=k; i<n; i++)
			for (j=i+1; j<=n; j++)
				{
				old = mat_elt(m, j, i);
				mat_elt(m, j, i) = integer_incref(mat_elt(m, i, j) ); 
				integer_delref(old);
				}
		*r1 = *r1 + integer_compare(mat_elt(m, k, k), 0)
			  * integer_compare(den, 0);
		old = den;
		den = integer_incref(mat_elt(m, k, k) );
		integer_delref(old); 
		}
	*r1 = *r1 + integer_compare(mat_elt(m, n, n), 0)
		  * integer_compare(den, 0);
	*r2 = (n - *r1)/2;
	old = integer_incref(mat_elt(m, n, n) );
	mat_delref(Z, &m);
	integer_delref(den); 
	if (old == 0)
		{
		*r1 = -1;
		*r2 = -1;
		}
	return old; 
} 

