/******************************************************************************
  lat_elt_to_anf_elt.c
******************************************************************************/
#include "kant.h"
#include "anf.h"
#include "lattice.h"

anf_elt
lat_elt_to_anf_elt WITH_3_ARGS (
	lattice,	lat,
	lat_elt,	lelt,
	order,		ord
)
/******************************************************************************
 
Description:	Converts a lattice element to an algebraic number.
 
Calling sequence:

	alpha = lat_elt_to_anf_elt(lat,elt,ord)

	anf_elt		alpha		= t_handle of algebraic number	 
	lattice		lat		= t_handle of lattice
	lat_elt		elt		= t_handle of lattice element
	order		ord		= t_handle of order
 
History:
 
	92-02-25 KW    written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		alpha;
	integer_small	i;
	integer_small	deg;

	deg = order_abs_degree(ord);

	anf_elt_alloc(alpha,deg);
	anf_elt_den(alpha) = 1;
	for(i=1;i<=deg;i++)
	{
		anf_elt_coef(alpha,i) = integer_incref(lat_elt_coef(lelt,i));
	}

	return(alpha);
}
