/******************************************************************************
  lat_gram_calc.c
******************************************************************************/
#include "kant.h"
#include "lattice.h"
#include "anf.h"

void
lat_gram_calc WITH_1_ARG(
	lattice,	lat
)
/******************************************************************************

Description:	Computes the gram matrix of a lattice basis.
		The result is stored inside the lattice structure.
 
Calling sequence:
 
	lat_gram_calc(lat)

	lattice		lat	= t_handle of lattice		
 
History:
 
	92-01-09 KW    written
 
******************************************************************************/
{
	block_declarations;

	if (!lat_basis_known(lat))
		error_internal("lat_gram_calc: Cannot calculate gram matrix without basis.");

	if (lat_gram_known(lat)) return;

	lat_gram(lat) = mat_ring_gram(lat_basis_ring(lat),lat_basis(lat));
	lat_gram_ring(lat) = ring_incref(lat_basis_ring(lat));

	return;
}


