/******************************************************************************
  mat_ring_gram.c
******************************************************************************/
#include "kant.h" 
#include "real.e"
#include "mat.h"
 
matrix
mat_ring_gram WITH_2_ARGS(
	t_handle,		gram_ring,
	matrix,		basis
)
/******************************************************************************
 
Description: Computes the gram matrix of a matrix.
 
Calling sequence:
 
	gram = mat_ring_gram(cring,mat)
	
	matrix		gram	= t_handle of the gram matrix of mat
	ring		cring	= t_handle of the mat-entries ring
	matrix		mat	= t_handle of matrix
 
History:
 
	92-01-09 KW    written
 
******************************************************************************/
{
	block_declarations;

	matrix	mat1,mat2;

	mat1 = mat_ring_trans(gram_ring,basis);
	mat2 = mat_ring_mult(gram_ring,mat1,basis);

	mat_delref(gram_ring,&mat1);

	return(mat2);
}

