/*******************************************************************************
  mat_ring_make_square_mat.c 
********************************************************************************/

         
#include <stdio.h>             
#include "kant.h"
#include "anf.h"
#include "mat.h"

   
matrix
mat_ring_make_square_mat WITH_2_ARGS ( t_handle , cring,
                                       matrix , mat   )
/*******************************************************************************

Description:                               

	Embeds a given matrix into a square matrix with      
	minimal dimension.                                   
                                                      

Calling sequence:                                      
                                                      
        mat = mat_ring_make_square_mat (cring,sub_matrix);


             t_handle    cring        : This is a t_handle to ring defined in Cayley
             matrix    sub_matrix   : A (n x m) matrix with coeff. in cring
 
             matrix    mat          : The return - value of the function.
                                      We define l := max (n,m) and mat to be 
                                      the samllest square matrix with sub_matrix
                                      the sub - matrix in the upper right area.
                                           

History:                                                       
	 91-11-10       first version 
                               
********************************************************************************/
{
    matrix        mat1,mat2;
    integer_small n,row,col;                                         


      
    row = mat_row (mat);
    col = mat_col (mat);
   
    n = (row > col ? row : col);

    mat1 = mat_ring_create_zero (cring,n);                           
    if (mat_is_packed(mat)) puts (" PACKED MATRIX");

    mat2 = mat_ring_insert (cring,mat1,mat,1,1);
    mat_delref (cring,&mat1);


    return mat2;
}

     
