/*******************************************************************************
  order_add.c
********************************************************************************/
                                                

#include "kant.h" 
#include "anf.h" 



order
order_add WITH_2_ARGS (order , ord1,
                       order , ord2 )
/*******************************************************************************
                                                                              
Description:
	The function adds two given orders of the same number - field.               
	The return - value is :                                                      
                           ord1 + ord2                                        
                                                                              
                                                                              
	So far the alg. works only under the following assumptions :                 
                                                                              
          1) both orders are given via a transformation matrix from the       
             same suborder (with the same size) :                             
                          order_suborder (ord1) = order_suborder (ord2)       
                                                                              
          2) the suborder have to have the same t_handle                        
                                                                              
          3) order_must_be_over_z  (order_suborder (ord1)) = TRUE             
        
Calling sequence
  
        ord = order_add (ord1,ord2);

        order or1,ord2          : two orders which fulfil the assumptions
                                  mentioned above.
        order ord               : the return value of the function.
                                  The order that is defined by the addition 
                                  of ord1 and or2.

                                                                      
History:                                                                              
        JS 06.07.92  trivial case ord1==ord2
        MD 06.03.92  mat_z_simplify added.
	MD 20.12.91  first version                                                   
/*******************************************************************************/


{         

     	  block_declarations;         
                          
          order           add_ord;
          order           sub_ord1,sub_ord2,Z;                         
          matrix          hnf_mat,trans_mat,temp1_mat,temp2_mat;
  
          integer_big     hnf_den;
          integer_small   degree;
 
  if (ord1 == ord2) return order_incref (ord1);                     

  if (order_basis_is_power (ord1)) return order_incref (ord2);
  if (order_basis_is_power (ord2)) return order_incref (ord1);


  if ( (!order_basis_is_rel (ord1)) || (!order_basis_is_rel (ord2)) || 
       (order_abs_degree (ord1) != order_abs_degree (ord2)) )
    error_internal ("ORDER_ADD : assumption (1) not given");

  sub_ord1 = order_suborder (ord1);
  sub_ord2 = order_suborder (ord2);

  if (sub_ord1 != sub_ord2) 
    error_internal ("ORDER_ADD : assumption (2) not given");                                             
  
  order_must_be_over_z (sub_ord1);

/* ok -- all assumptions are given  */
  if (order_basis_is_power (ord1)) return order_incref (ord2);
  if (order_basis_is_power (ord2)) return order_incref (ord1);

          
  if (order_index (ord1) ==1) return order_incref (ord2);
  if (order_index (ord2) ==1) return order_incref (ord1);                     

  Z = order_coef_order (ord1);
  degree = order_rel_degree (ord1);    

  temp1_mat = mat_z_scalar_mult (Z,order_tran (ord1),order_tran_den (ord2));
  temp2_mat = mat_z_scalar_mult (Z,order_tran (ord2),order_tran_den (ord1));

  trans_mat = mat_new (degree,2*degree);      
  hnf_mat = mat_ring_insert (Z,trans_mat,temp1_mat,1,1);
  mat_delref (Z,&trans_mat);
                                    
  trans_mat = hnf_mat;
  hnf_mat = mat_ring_insert (Z,trans_mat,temp2_mat,1,degree+1);
  mat_delref (Z,&trans_mat);
  mat_delref (Z,&temp1_mat);
  mat_delref (Z,&temp2_mat);

 
  trans_mat = hnf_mat;
  hnf_mat = mat_ring_hnf_col_upper (Z,trans_mat);  /* hermite reduction */
  mat_delref (Z,&trans_mat);                                        


  hnf_den = integer_mult (order_tran_den (ord1),order_tran_den (ord2));

 
  trans_mat = mat_ring_submat (Z,hnf_mat,1,1,degree,degree);
  mat_delref (Z,&hnf_mat);
                      
                                          
  mat_z_simplify (Z,trans_mat,&hnf_den);

  if (anf_print_level >3) 
  {
    printf ("Transformation for added order\n"); 
    cay_print (" Den : %d \n",hnf_den);
    mat_anf_write (Z,trans_mat);
  }  
            
  add_ord = order_trans (sub_ord1,trans_mat,hnf_den);
  mat_delref (Z,&trans_mat);
  integer_delref (hnf_den);
 

  return add_ord;
}

