#include "kant.h"
#include "anf.h"
#include "anf.e"
#include "q.h"
#include "globals.e"
#include "ring.e"
#include "conv.e"
#ifndef KANT
#include "alg.e"
#endif

t_logical
order_elt_coerce(qring, str, elt, itm, nelt, nitm, do_error)
t_handle	qring;
t_handle	str;
t_handle	elt;
t_int		itm;
t_handle	*nelt;
t_int		*nitm;
t_logical	do_error;
/*
** Lift elt into qring (order)
*/
{
	block_declarations;
	order		eqord;
	t_logical	res;

	ASSERT (structure_repnum (qring) == REP_ORDER);

	*nitm = 0;
	switch (ring_type(str))
	{
	case RING_Z:
		*nelt = integer_incref(elt);
		break;
	case RING_ORDER:
		if (order_anf(str) != order_anf(qring))
			return FALSE;
		return anf_elt_order_coerce(str, elt, qring, nelt);
		break;
	case RING_ANF:
		if (str != order_anf(qring))
			return FALSE;
		eqord = anf_order_equation(str);
		res =  anf_elt_order_coerce(eqord, elt, qring, nelt);
		order_delete(&eqord);
		return res;
		break;
	default:
		return FALSE;
	}

	return TRUE;
}

