#include "kant.h"
      
t_logical
order_hom_tower_find WITH_3_ARGS(
        order,                   ord1,
        order,                   ord2,
        dyn_arr_handle*,         a)
                 
/*********************************************************************************

Description: 
        Tries to find ord1 as subfield_order of ord2. If it returns TRUE the
        dynamic array a contains the handles of the orders (form ord2 to ord1).
        The first entry of this dyn_arr will contain a subfield of ord2 and
        the last will be ord1 itself. 
        If ord1==ord2 *a will not be allocated at all.
        Before entry, a must have been set to 0.

Calling sequence:
        L = order_hom_tower_find(ord1, ord2, &a);

                L       t_logical
                ord1    order
                ord2    order
                a       dyn_array_handle
       
History:
	92-09-17 JS  several changes
	92-06-12 JPS written
*********************************************************************************/
        {
	block_declarations;

	integer_small		i, k, len_a;	
        t_logical                 exit;
                        
        if (anf_print_level > 2) 
                printf("Trying to find tower from %d up to %d...\n", ord1, ord2);
        if (ord1 == ord2)
                return TRUE;

        k = order_subfield_order_count(ord2);
        if (k == 0) return FALSE;
        exit = FALSE;
        i = 1;
        if (*a == 0)
                {
                *a = dyn_arr_alloc(1);
                dyn_arr_curr_length(*a) = 0;  
                }
        len_a = dyn_arr_curr_length(*a);
        ++len_a;
        dyn_arr_assure_space_fun(*a, len_a, 10);
        dyn_arr_curr_length(*a) = len_a;
        while (i<=k)
                { 
                dyn_arr_element(*a, len_a-1) = ring_incref(order_subfield_order(ord2, i)); 
                exit = order_hom_tower_find(ord1, order_subfield_order(ord2, i), a);
                if (exit)
                        {              
                        printf("Tower found: length = %d (suborder #%d).\n", 
				dyn_arr_curr_length(*a), i);
                        return TRUE;
                        }
              	else
                        {
                        ring_delete(&dyn_arr_element(*a, len_a-1));
                        ++i;
                        }
                }
                dyn_arr_curr_length(*a) = len_a -1;
		return FALSE;
        }
