/******************************************************************************
  order_units_voronoi.c
******************************************************************************/
 
#include "kant.h"        
  
t_void
order_units_voronoi WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
                   
Description: 
 
 	Computes the fundamental units of an order with unit rank 1.
        This method is explained in detail in
        J. Buchmann,  A generalization of Voronoi's unit algorithm I, II, 
        J. Number Theory 20 (1985), 177-209.
 
        The regulator is computed automatically.
 
 
Calling sequence: 
	
	order_units_voronoi(ord);
                               
	order		ord    = t_handle of the order

  
History:

        92-09-09 JS    anf_elt_norm_abs                
 	92-03-01 MJ 	first version
 
*******************************************************************************/
{
	block_declarations;         
  
	anf_elt	  	temp1, temp2, unit, neighbor;
	anf_ideal  	id, id1,id2;   
        integer_small   flag, p; 
        integer_big     norm, den;
 
        if (anf_print_level > 0) puts("Start Voronoi algorithm...");

        order_mult_assure(ord);
        order_reals_assure(ord);

	id 	= anf_ideal_2_create(ord, 1, 0);
	id2 	= anf_ideal_2_create(ord, 1, 0);
        unit	= 1;
        p 	= 0;
        flag 	= 0;
        while( flag == 0 )
	{          
           p++;
           neighbor = anf_ideal_neighbor(ord,id,2);  
           temp1 = unit;
	   temp2 = anf_elt_mult(ord,temp1,neighbor); 
           anf_elt_delete(ord, &temp1);
       
           unit  = anf_elt_simplify(ord, temp2);
           anf_elt_delete(ord, &temp2);
  
           if (anf_print_level > 3)
           {
                printf("(%d)  Neighbor is: ",p); 
		anf_elt_write(ord,neighbor); 
		printf("\n");
           }
 
           id1 = anf_ideal_anf_elt_div(ord,id,neighbor);
           anf_ideal_delete(ord, &id);
           anf_elt_norm_abs(ord,unit,&norm,&den); 

           if (anf_print_level > 3)
           {
           	printf("(%d)  Product is:  ",p); 
           	anf_elt_write(ord, unit); 
           	printf("    with norm and den: "); 
           	integer_write(norm);   
           	printf("  ");
           	integer_write(den);   
           	printf("\n");
           }

           if ( !integer_compare(norm,1) )
           {
                   order_units_count_set(ord, 1);
                   order_unit(ord, 1) = unit;
                   order_set_units_are_fund(ord);
         	   order_units_logs_calc(ord);
		   order_reg_calc(ord);
                   if (anf_print_level > 0)
                   {
        	   	printf("Period length: %d      Regulator:", p);
                        real_write(order_reals(ord), order_reg(ord), 30);
                        puts("");
                   }
            	flag = 1;
           }                           
 
           id = id1; 
           anf_elt_delete(ord, &neighbor);
           integer_delref(norm);
           integer_delref(den);
        }
 
        anf_ideal_delete(ord, &id);
        anf_ideal_delete(ord, &id2);
 
        return;
}
	 
