#include "kant.h" 
#include <math.h>
 
integer_small
real_compare_eps WITH_4_ARGS(
	t_handle,		r,
	t_real,		a,
	t_real,		b,
        t_real,         eps
)
/*******************************************************************************
 
Description:
 
	Compares real a and b (with error eps), returning:

	 	-1	if   a - b    <  -(eps*pow_eps),
		 0	if  |a - b|  <=   eps*pow_eps,
		 1	if   a - b    >    eps*pow_eps,

	where pow_eps= max(mp_expt(a)*log10(bse), mp_expt(b)*log10(bse) ).
	We cannot guarantee for the exact precision of this function.
	

 
Calling sequence:
 
	flag= real_eq(r, a, b, eps);
 
      	t_handle      r        = real ring
	t_real	    a	     = first t_real number      
	t_real	    b	     = second t_real number      
	t_real	    eps	     = precision of the comparisation
 
History:
 
	92-02-04 AJ    written
 
*******************************************************************************/
{
    t_real		diff, h, eps_new, pow_eps; 
    int         	erg, a_maxexpt, b_maxexpt, maxexpt, result;
    double		log10_bse= 4.214420; /* bei mp_bse= 16384 */
    mp_float            x, y;
    mp_ptr_type		xp, yp;
    mp_expt_type	xp_expt, yp_expt; /* int */ 


/*** Initialisation  **********************************************************/

             
    real_make_mp(a, x);
    real_make_mp(b, y);
    xp = mp_ptr(x);
    yp = mp_ptr(y);

    if (mp_b(xp) != mp_b(yp))
	mp_error("real_compare_eps: x and y have different bases");
      
    xp_expt=  mp_expt(xp);
    yp_expt=  mp_expt(yp);  

/*** Relative eps will be computed  *******************************************/

    a_maxexpt= conv_double_to_int_round(log10_bse) * xp_expt;
    b_maxexpt= conv_double_to_int_round(log10_bse) * yp_expt;
    maxexpt= max(a_maxexpt, b_maxexpt);

    if (anf_print_level >=8 )
     {
      printf("\nreal_compare_eps:\n"); 		   
      printf("a_maxexpt:  %d\n", a_maxexpt);
      printf("b_maxexpt:  %d\n", b_maxexpt);
      printf("maxexpt:    %d\n", maxexpt);
      printf("eps:     "); real_write(r, eps, 20); printf("\n");
     }
       
    pow_eps= real_make(r, 10, maxexpt);
    eps_new= real_mult(r, eps, pow_eps);
    real_delete(&pow_eps);

    if (anf_print_level >=8 ) 
     {
      printf("eps_new: "); real_write(r, eps_new, 20); printf("\n");
     }

/*** Comparisation ************************************************************/

    diff= real_subtract(r, a,b);
    erg= real_compare(r, diff, eps_new); 
    if (erg==1) 
       result= 1;
     else
      {
       h= diff;
       diff= real_abs(r, h);  
       real_delete(&h);
       erg= real_compare(r, diff, eps_new); 
       if ( (erg==0) || (erg==-1) )  
	 result= 0;
	else
         result=  -1;
      }

    real_delete(&diff);
    real_delete(&eps_new);

/*** End ********************************************************************/

    return result;
}


