#include "mem.h"

t_ptr memi_coalesce_right(bp)
t_ptr bp;
/*
Coalesce the block pointed to by bp with the block to the right of it
if it is free.  Return the new next block if a coalesce was possible;
NULL otherwise.
*/
{
    t_ptr	nextp, next;

    nextp = (t_ptr)&NEXT_BLOCK(bp);
    next = DEREF(nextp);

    if (IS_FREE(BLOCK_HANDLE(next)))
    {
	t_ptr	next_next, prev;

	ASSERT(next < memi_high_mem);

	next_next = NEXT_FREE(next);
	prev = PREV_FREE(next);
	DEREF(prev) = next_next;
	if (next_next)
	    PREV_FREE(next_next) = prev;
	next = NEXT_BLOCK(next);

	DEREF(nextp) = next;
	PREV_BLOCK(next) = bp;
	return next;
    }

    return NULL;
}

t_ptr memi_coalesce_block(bp)
t_ptr bp;
/*
Coalesce block bp on both sides if possible and return the new block.
*/
{
    t_ptr	h_bottom, h_top, nextp, next, orig_next, high_mem, hp;
    t_int	changed;

    changed = FALSE;
    h_bottom = HANDLE_BASE;
    h_top = memi_handle_limit;

    nextp = (t_ptr)&NEXT_BLOCK(bp);
    next = DEREF(nextp);

    IF_ANALYSIS(
	memi_analysis_coalesce++;
	memi_analysis_coalesce_original += next - bp
    )

    if (IS_FREE_L(BLOCK_HANDLE(next), h_top, h_bottom))
    {
	t_ptr	next_next, prev;

	next_next = NEXT_FREE(next);
	prev = PREV_FREE(next);
	DEREF(prev) = next_next;
	if (next_next)
	    PREV_FREE(next_next) = prev;
	next = NEXT_BLOCK(next);
	changed = TRUE;

	IF_ANALYSIS(
	    memi_analysis_coalesce_right++;
	)
    }

    if (bp > memi_base_mem)
    {
	t_ptr	prev;

	prev = PREV_BLOCK(bp);
	if (IS_FREE_L(BLOCK_HANDLE(prev), h_top, h_bottom))
	{
	    t_ptr	prev_next, prev_prev;

	    prev_next = NEXT_FREE(prev);
	    prev_prev = PREV_FREE(prev);
	    DEREF(prev_prev) = prev_next;
	    if (prev_next)
		PREV_FREE(prev_next) = prev_prev;
	    bp = prev;
	    nextp = (t_ptr)&NEXT_BLOCK(bp);

	    IF_ANALYSIS(
		memi_analysis_coalesce_left++;
		if (changed)
		    memi_analysis_coalesce_both++;
	    )

	    changed = TRUE;
	}
    }

    if (changed)
    {
	DEREF(nextp) = next;
	PREV_BLOCK(next) = bp;
    }

    IF_ANALYSIS(
	memi_analysis_coalesce_after += next - bp;
	if (!changed)
	    memi_analysis_coalesce_none++;
    )

    return bp;
}
