#include "mem.h"

t_void memi_move_block_down(s, d)
t_ptr	s, d;
{
    t_ptr	e;

    ASSERT(d <= s);
    e = NEXT_BLOCK(s) - HEADER_SIZE;
    while (s < e)
	*d++ = *s++;
}

t_void mem_compact()
/*
Compact all handle blocks.
*/
{
    t_ptr	left, right, high_mem, hp, left_next, bp, right_next;
    t_ptr	old_base, old_next_handle, new_base;
    t_ptr	h_bottom, h_top;
    t_ptr	max_block, max_block_next;
    t_len	size, diff, free_size, max_size;

    for (left = (t_ptr)memi_free_lists; left < (t_ptr)memi_free_limit; left++)
	DEREF(left) = NULL;

    left = memi_base_mem;
    high_mem = memi_high_mem;

    h_bottom = HANDLE_BASE;
    h_top = memi_handle_limit;

    for (;;)
    {
	while (left < high_mem)
	{
	    hp = BLOCK_HANDLE(left);
	    if (IS_FREE_L(hp, h_top, h_bottom))
		break;
	    left = NEXT_BLOCK(left);
	}

	if (left == high_mem)
	    break;

	/*
	Found a free block.  Look for handle blocks to the right of it.
	*/

	right = left;

	while (right < high_mem)
	{
	    hp = BLOCK_HANDLE(right);
	    if (IS_ACTIVE_L(hp, h_top, h_bottom))
	    {
		/*
		Move the block down to left and update left.
		*/

		right_next = NEXT_BLOCK(right);
		size = BLOCK_SIZE(right);
		left_next = left + size;

		IF_TRACE_ALLOCS(
		    BLOCK_FILE_NAME(left) = BLOCK_FILE_NAME(right);
		    BLOCK_LINE_NUM(left) = BLOCK_LINE_NUM(right);
		)

		IF_USE_MARKS(
		    BLOCK_MARK(left) = BLOCK_MARK(right);
		)

		memi_move_block_down(right, left);

		NEXT_BLOCK(left) = left_next;
		PREV_BLOCK(left_next) = left;
		BLOCK_HANDLE(left) = hp;
		DEREF(hp) = left;

		left = left_next;
		right = right_next;
	    }
	    else if (hp == P_HANDLE_TABLE)
	    {
		/*
		Move the handle table down, updating all blocks.
		*/

		ASSERT(right == h_bottom);
		ASSERT(right + BLOCK_SIZE_NO_HEADER(right) == h_top);

		old_base = right + 1;
		old_next_handle = memi_next_handle;
		new_base = left + 1;
		diff = left - right;

		right_next = NEXT_BLOCK(right);
		size = BLOCK_SIZE(right);

		while (old_base < old_next_handle)
		{
		    bp = DEREF(old_base++);
		    if (!bp || bp == P_DELETED_HANDLE)
			DEREF(new_base) = bp;
		    else if (bp >= h_bottom && bp < h_top)
			DEREF(new_base) = bp + diff;
		    else
		    {
			DEREF(new_base) = bp;
			BLOCK_HANDLE(bp) = new_base;
		    }
		    new_base++;
		}

		left_next = left + size;
		NEXT_BLOCK(left) = left_next;
		PREV_BLOCK(left_next) = left;
		BLOCK_HANDLE(left) = hp;
		left = left_next;
		right = right_next;

		HANDLE_BASE += diff;
		memi_handle_limit += diff;
		memi_next_handle += diff;
		if (memi_free_handle_list)
		    memi_free_handle_list += diff;

		h_bottom = HANDLE_BASE;
		h_top = memi_handle_limit;

	    }
	    else if (IS_FIXED(hp))
	    {
		/*
		Right block is fixed.  Move the biggest block to the right
		of it which fits into the free space.
		*/

		bp = NEXT_BLOCK(right);
		free_size = right - left;
		max_size = 0;

		while (bp < high_mem)
		{
		    size = BLOCK_SIZE(bp);
		    if (
			size > max_size && size <= free_size &&
			IS_ACTIVE_L(BLOCK_HANDLE(bp), h_top, h_bottom)
		    )
		    {
			max_size = size;
			max_block = bp;
		    }
		    bp = NEXT_BLOCK(bp);
		}

		if (max_size)
		{
		    hp = BLOCK_HANDLE(max_block);
		    BLOCK_HANDLE(max_block) = NULL;
		    max_block_next = NEXT_BLOCK(max_block);
		    left_next = left + max_size;

		    IF_TRACE_ALLOCS(
			BLOCK_FILE_NAME(left) = BLOCK_FILE_NAME(max_block);
			BLOCK_LINE_NUM(left) = BLOCK_LINE_NUM(max_block);
		    )

		    IF_USE_MARKS(
			BLOCK_MARK(left) = BLOCK_MARK(max_block);
		    )

		    memi_move_block_down(max_block, left);

		    if (max_size + MIN_SIZE > free_size)
		    {
			t_ptr	limit;

			limit = right - HEADER_SIZE;
			while (left_next < limit)
			    DEREF(left_next++) = NULL;

			left_next = right;
		    }

		    NEXT_BLOCK(left) = left_next;
		    PREV_BLOCK(left_next) = left;
		    BLOCK_HANDLE(left) = hp;
		    DEREF(hp) = left;

		    left = left_next;
		    if (left == right)
			break;
		}
		else
		{
		    /*
		    There's nothing at all to fit in.
		    */

		    NEXT_BLOCK(left) = right;
		    PREV_BLOCK(right) = left;
		    memi_free_block(left);

		    left = right;
		    break;
		}
	    }
	    else
	    {
		ASSERT(IS_FREE_L(hp, h_top, h_bottom));
		right = NEXT_BLOCK(right);
	    }
	}

	if (right == high_mem)
	{
	    NEXT_BLOCK(left) = right;
	    PREV_BLOCK(right) = left;
	    memi_free_block(left);
	    break;
	}
    }
}
