#include "mem.h"

t_int memi_more_data(n, gapsize, datap)
t_len	n, gapsize;
t_ptr	*datap;
/*
Get n more ptrs of data for the process address space - if a gap has arrived,
get gapsize ptrs instead.  Assigns *datap to beginning of new data.
Returns whether there was a gap.
*/
{
    static	t_len used_mem;
    t_ptr	s, old_high_mem;
    t_int	gap;
    t_len	try;

    CHECK_FOR_GAP(gap);
    if (gap)
	n = gapsize + HEADER_SIZE;

    n = SBRK_ALIGN(n * sizeof(t_ptr));

    try = n;
    if (mem_size_limit)
    {
	t_len	left;

	left = mem_size_limit - used_mem;
	if (left < n)
	    (*mem_callback)(MEM_CALLBACK_HIT_LIMIT);

	if (n < mem_extension_size)
	{
	    try = SBRK_ALIGN(mem_extension_size);
	    if (left < try)
		try = SBRK_ALIGN_DOWN(left);
	}
    }
    else
    {
	if (n < mem_extension_size)
	    try = SBRK_ALIGN(mem_extension_size);
    }

    s = (t_ptr)SBRK(try);

    if (s == SBRK_FAIL)
    {
	s = SBRK(n);
	if (s == SBRK_FAIL)
	    (*mem_callback)(MEM_CALLBACK_NO_ROOM);
    }
    else
	n = try;

    used_mem += n;

    old_high_mem = memi_high_mem;
    memi_high_mem = (t_ptr)((char *)s + n);

    if (gap)
    {
	VERBOSE(
	    mem_printf(
		"mem: gap of size %d at %x; making special block\n",
		PTRS_TO_BYTES(s - old_high_mem), old_high_mem
	    )
	);

	/*
	Advance s because the header is behind s.
	*/

	s += HEADER_SIZE;
	if (memi_base_mem)
	{
	    BLOCK_HANDLE(old_high_mem) = P_SBRK_GAP;
	    NEXT_BLOCK(old_high_mem) = s;
	    PREV_BLOCK(s) = old_high_mem;
	}
    }

    if (memi_base_mem == NULL)
	memi_base_mem = s;

    *datap = s;
    BLOCK_HANDLE(memi_high_mem) = P_HIGH_MEM;

    VERBOSE(
	mem_printf(
	    "mem: more_data(%d), total memory: %d\n",
	    n, PTRS_TO_BYTES(memi_high_mem - memi_base_mem)
	)
    );

    return gap;
}
