#include "mem.h"

#ifdef DEVELOP
t_void memi_trace_init()
{
    memi_trace_h_table = (char *)mem_calloc(TRACE_H_INITIAL, 1);
    memi_trace_h_len = TRACE_H_INITIAL;
    memi_trace_size_table = (char *)mem_calloc(TRACE_SIZE_INITIAL, 1);
    memi_trace_size_len = TRACE_SIZE_INITIAL;
}

t_void memi_trace_h(f, h, UFILE, ULINE)
char	 *f, *UFILE;
t_handle h;
t_int	 ULINE;
{
    printf(
	"[%-15s h: %d, file: %s, line: %d]\n",
	mem_strip_head(f), h, UFILE, ULINE
    );
}

t_void memi_trace_size(f, h, s, UFILE, ULINE)
char	 *f, *UFILE;
t_handle s;
t_int	 ULINE;
{
    printf(
	"[%-15s size: %d, handle: %d, file: %s, line: %d]\n",
	mem_strip_head(f), s, h, UFILE, ULINE
    );
}

t_void memi_check_trace(f, h, n, UFILE, ULINE)
char	 *f, *UFILE;
t_handle h;
t_int	 n, ULINE;
{
    t_int	hn, ind, mask;

    hn = HNORM(h);
    ind = hn >> 3;
    mask = 1 << (hn & 7);
    if (ind < memi_trace_h_len && (memi_trace_h_table[ind] & mask))
	memi_trace_h(f, h, UFILE, ULINE);

    ind = n >> 3;
    mask = 1 << (n & 7);
    if (ind < memi_trace_size_len && (memi_trace_size_table[ind] & mask))
	memi_trace_size(f, h, n, UFILE, ULINE);
}

t_void mem_set_trace_handle(h, val)
t_handle h;
t_int    val;
{
    t_handle hn;
    t_int    ind, mask, orig;

    hn = HNORM(h);
    ASSERT(hn > 0);
    ind = hn >> 3;
    mask = 1 << (hn & 7);

    if (ind >= memi_trace_h_len)
    {
	char	*p, *ep;
	orig = memi_trace_h_len;
	memi_trace_h_len = ind + 10;
	memi_trace_h_table = (char *)mem_realloc(
	    memi_trace_h_table, memi_trace_h_len
	);
	p = memi_trace_h_table + orig;
	ep = memi_trace_h_table + memi_trace_h_len;
	while (p < ep)
	    *p++ = 0;
    }
    if (val)
	memi_trace_h_table[ind] |= mask;
    else
	memi_trace_h_table[ind] &= ~mask;
}

t_void mem_set_trace_size(n, val)
t_int n;
t_int    val;
{
    t_int    ind, mask, orig;

    ind = n >> 3;
    mask = 1 << (n & 7);

    if (ind >= memi_trace_size_len)
    {
	char	*p, *ep;
	orig = memi_trace_size_len;
	memi_trace_size_len = ind + 10;
	memi_trace_size_table = (char *)mem_realloc(
	    memi_trace_size_table, memi_trace_size_len
	);
	p = memi_trace_size_table + orig;
	ep = memi_trace_size_table + memi_trace_size_len;
	while (p < ep)
	    *p++ = 0;
    }
    if (val)
	memi_trace_size_table[ind] |= mask;
    else
	memi_trace_size_table[ind] &= ~mask;
}
#endif
