
#include "defs.h"
#include "mp.e"
#include "real.e"
#include "comp.e"

t_comp
comp_make WITH_3_ARGS(
	t_handle,		r,
	t_real,		re,
	t_real,		im
)
/*
** Input : r = t_handle to complex field;
** Output : a complex of r with members a COPY of re and im.
** Returns the complex number with real part re, imaginary part im, assuming
** that re and im are both elements of the field over which r is defined.
*/
{
	t_comp		a;
	mp_float	are, aim;
	mp_float	ref, imf;

	/* The following is a macro call - no copy made. */
	real_make_mp( re, ref );
	real_make_mp( im, imf );

	a = comp_alloc( real_base, comp_beta_prec( r ) );
	comp_split_mp( a, are, aim );

	/* This is where the copy takes place. */
	mp_priv_copy( ref, are );
	mp_priv_copy( imf, aim );

	return a;
}

