
#include "defs.h"
#include "comp.e"
#include "real.e"
#include "mp.e"

t_real
comp_modulus WITH_2_ARGS(
	t_handle,		r,
	t_comp,		x
)
/*
** Returns modulus( x ) = || x ||.
*/
{
	mp_float	xre, xim;
	mp_float	yf, temp1;

	comp_split_mp( x, xre, xim );
	yf = mp_alloc( real_base, comp_beta_prec( r ));
	temp1 = mp_alloc( real_base, comp_beta_prec( r ));
	mp_mul( xre, xre, temp1 );
	mp_mul( xim, xim, yf );
	mp_add( yf, temp1, yf );
	mp_sqrt( yf, yf );
	mp_delete_float( temp1 );

	return mp_to_real( yf );
}

