
#include "defs.h"
#include "real.e"
#include "integer.e"
#include "real.e"
#include "comp.e"
#include "mp.e"
#include "mp.h"
#include "conv.e"


t_comp
conv_real_to_comp WITH_2_ARGS(
	t_handle,		cfld,
	t_real,		a
)
/*
** Converts a into a complex number. Does not assume that a comes from
** the real field upon which cfld was constructed.
*/
{
	t_comp		b;
	mp_float	bre, bim, af;

	real_make_mp( a, af );

	b = comp_alloc( real_base, comp_beta_prec( cfld ));
	comp_split_mp( b, bre, bim );

	mp_priv_move( af, bre );
	mp_int_to_mp( 0, bim );

	return b;
}

