#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

int
ib_log2     WITH_1_ARG(
    int,    adig
)
/*
** input:  adig - beta-digit
** output: ib_log2 = { 0                                    if adig = 0
**                   { integral part (log2 (|adig|)) + 1    if adig <> 0
** - a beta-digit
** ib_log2 computes the log to the base 2 of adig
** case adig = 0?
*/
{
    register int    i;
    register int    j;
    register int    n;
    register int    abar;


    if (adig == 0)
    {
	return 0;
    }
    /*
     * case adig is non-zero...
     */
    abar = (adig >= 0) ? adig : -adig;
    i = 1;
    j = ZETA + 1;
    /*
     * repeat loop to binary search itabp2 for correct power
     */
    do
    {
        n = (i + j) / 2;
        if (abar >= (1 << (n-1)))
	    i = n;
        else
	    j = n;
    }
    while (j - i != 1);

    return i;
}
