#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


#ifdef USE_DOUBLE_MULT

/*
Evaluate 1/BETA at compile time.
*/

double BETA_INV = 1.0 / BETA;

#endif



#if 0

/*
Old (signed) version - now obsolete - see intbig.h.
*/

#undef ib_mult


void
ib_mult	WITH_4_ARGS(
    integer_small,	diga,
    integer_small,	digb,
    integer_small *,	carry,
    integer_small *,	prod
)
/*
Given beta-digits diga and digb, calculate the unique beta-digits carry
and prod such that

	diga * digb = carry*BETA + prod
and
	carry * prod >= 0	(i.e. they have the same sign).
*/
{
    register integer_small	a0;
    register integer_small	a1;
    register integer_small	b1;
    register integer_small	b0;
    register intbig_medium	c2;
    register intbig_medium	c00;
    register intbig_medium	c01;
    register intbig_medium	c10;
    register intbig_medium	c11;
    register intbig_medium	cdash;
    register intbig_medium	prdash;

#if 0
    a1 = diga / EPSILON;
    a0 = diga - a1 * EPSILON;
    b1 = digb / EPSILON;
    b0 = digb - b1 * EPSILON;
#else
    a1 = diga >> ((ZETA+1)/2);
    a0 = diga - (a1 << ((ZETA+1)/2));
    b1 = digb >> ((ZETA+1)/2);
    b0 = digb - (b1 << ((ZETA+1)/2));
#endif

    c00 = a0 * b0;

    if (c00 >= BETA)
    {
	c01 = 1;
	c00 -= BETA;
    }
    else if (c00 <= -BETA)
    {
	c01 = -1;
	c00 += BETA;
    }
    else
	c01 = 0;

    c10 = a1 * b0 + a0 * b1;
    c11 = c10 / DELTA;
    c10 -= c11 * DELTA;

    c2 = a1 * b1;
    cdash = c2 + c01 + c11;

    if (DELTA != EPSILON)
	cdash += c2;

    prdash = c10 * EPSILON + c00;

    if (prdash >= BETA)
    {
	*carry = cdash + 1;
	*prod = prdash - BETA;
    }
    else if (prdash <= -BETA)
    {
	*carry = cdash - 1;
	*prod = prdash + BETA;
    }
    else
    {
	*carry = cdash;
	*prod = prdash;
    }

}
#endif
