#if 0
#include "types.h"
#include "integer.e"
#include "cay_string.h"

#define STRING_MAX	2048	/* Maximum length of a number */

static char	*s;

Private Void
put_digit WITH_1_ARG(
	long,	digit
)
/*
Put the character represented by digit into string s
*/
{
	*s++ = (char) digit;
}

strings
integer_int_to_str WITH_1_ARG(
	integer_big,	n
)
/*
Return a Cayley string containing the decimal representation of the integer n.
*/
{
	char	str[STRING_MAX];
	strings	result;
	integer_small	len;
	integer_small	i;
	double		l;
	Logical		all;
	t_handle		h;

	/*
	** We accumulate the string in str.
	*/

	/*
	** test for number of binary digits, check if #digits / 3.3219 is too
	** long. 3.3219 = log_2 ( 10 )
	*/

	l = (double) integer_log2( n );

	if ( l > (STRING_MAX-5) * 3.3219 )
	{
		h = mem_alloc_zero( (int) ((l+5.0)/3.3219) );
		s = (char *) mem_access( h );
		all = TRUE;
	}
	else
	{
		s = str;
		all = FALSE;
	}

	integer_break(n, put_digit);
	*s = '\0';

	/*
	Now turn the C string into a Cayley string
	*/
	if ( all )
	{
		s = (char *) mem_access( h );
	}
	else
	{
		s = str;
	}

	len = strlen(s);
	result = string_new(len);
	if ( all )
	{
		s = (char *) mem_access( h );
	}
	else
	{
		s = str;
	}

	for (i = 0; i < len; i++)
		string_put(result, i + 1, s[i]);

	if ( all )
	{
		mem_delete_h( h );
	}

	return result;
}
#endif
