#include "defs.h"
#include "integer.e"

Void
integer_least_prime_divisor WITH_4_ARGS(
    integer_small,      n,
    integer_small *,    p,
    integer_small *,    e,
    integer_small *,    m
)
/*
** Given a small integer n, find the smallest prime p that divides
** n and return p, e where p^e divides n but p^(e+1) does not,
** and m where m = n / p^e.
*/
{
	if (n == 1)
	{
		*p = 1;
		*e = 0;
		*m = 1;
		return;
	}

	/*
	 * Find a factor p by trial division
	 */
	i_trial_div_factor(n, 2, n, p, m);
	*e = 1;
	while (*m % *p == 0)
	{
		*m /= *p;
		++*e;
	}
}
