/*
inthdl_alloc.c
*/

#include "defs.h"
#include "inthdl.e"
#include "intbig.h"


#if 0
inthdl_handle inthdl_buf[INTHDL_TOTAL_BUFS];


inthdl_buf_index	inthdl_buf_next_index;

void
inthdl_init_bufs()
/*
Initialize all the buffers (i.e. allocated handles).
*/
{

    t_int	i;

    for (i = 0; i < INTHDL_TOTAL_BUFS; i++)
    {
	inthdl_buf[i] = inthdl_alloc(INTHDL_BUF_DIGITS);
	intbig_buf_index(inthdl_buf[i]) = i;
    }
    inthdl_buf_next_index = 0;
}
#endif


inthdl_handle
inthdl_alloc	WITH_1_ARG(
    inthdl_length, len
)
/*
Allocate and initialize a block for a big integer with room for len beta-digits.
The values of the digits are initially undefined.
*/
{
    inthdl_handle h;

    h = mem_alloc_words(intbig_required_space(len));
    block_init(h, INTBIG_BLOCK_TYPE);

    intbig_sign(h) = 0;
#if 0
    intbig_buf_index(h) = -1;
#endif

    DEBUG_INTHDL_BETA(".inthdl_alloc", h, len);

    return h;
}




inthdl_handle
inthdl_alloc_1	WITH_1_ARG(
    t_int, dig
)
/*
Allocate a block for a big integer with one beta-digit; set up
its header and the value of the digit
*/
{
    inthdl_handle h = mem_alloc_words(intbig_required_space(1));

    block_init(h, INTBIG_BLOCK_TYPE);
#if 0
    intbig_buf_index(h) = -1;
#endif

    if (dig > 0)
    {
	intbig_sign(h) = 1;
	intbig_curr_size(h) = 1;
	intbig_digit(h, 0) = dig;
    }
    else if (dig < 0)
    {
	intbig_sign(h) = -1;
	intbig_curr_size(h) = 1;
	intbig_digit(h, 0) = -dig;
    }
    else
	intbig_sign(h) = 0;

    return h;
}

inthdl_handle
inthdl_alloc_2	WITH_2_ARGS(
    t_int, dig1,
    t_int, dig2
)
/*
Allocate a block for a big integer with two beta-digits, of which the
more significant (dig2) is nonzero; set up its header and the value of
the digits (assuming that the digits have the same sign).
*/
{
    inthdl_handle h = mem_alloc_words(intbig_required_space(2));

    block_init(h, INTBIG_BLOCK_TYPE);
    intbig_curr_size(h) = 2;
#if 0
    intbig_buf_index(h) = -1;
#endif

    if (dig2 > 0)
    {
	if (dig1 >= 0)
	{
	    intbig_sign(h) = 1;
	    intbig_digit(h, 0) = dig1;
	    intbig_digit(h, 1) = dig2;
	}
	else
	    DIE();
    }
    else if (dig2 < 0)
    {
	if (dig1 <= 0)
	{
	    intbig_sign(h) = -1;
	    intbig_digit(h, 0) = -dig1;
	    intbig_digit(h, 1) = -dig2;
	}
	else
	    DIE();
    }
    else
	DIE();

    return h;
}


inthdl_handle
inthdl_buf_alloc_1	WITH_1_ARG(
    t_int, dig
)
/*
Return a buffer for a big integer with one beta-digit; set up
its header and the value of the digit
*/
{
    inthdl_handle h = inthdl_buf_alloc(1);

    if (dig > 0)
    {
	intbig_sign(h) = 1;
	intbig_curr_size(h) = 1;
	intbig_digit(h, 0) = dig;
    }
    else if (dig < 0)
    {
	intbig_sign(h) = -1;
	intbig_curr_size(h) = 1;
	intbig_digit(h, 0) = -dig;
    }
    else
	intbig_sign(h) = 0;

    return h;
}
