#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

t_int
inthdl_log2 WITH_1_ARG(
    inthdl_handle,  ahdl
)

/*
 *  Input:  ahdl - infinite precision integer
 *  Output: if ahdl is zero, returns zero
 *          otherwise, return log to the base 2 of ahdl
 */

{
    register    inthdl_handle   alen;

    DEBUG_INTHDL_1(".inthdl_log2", ahdl);

    if (intbig_sign(ahdl) == 0)
	return 0;

    alen = intbig_curr_size(ahdl);

    return (ZETA * (alen - 1) + ib_log2(intbig_digit(ahdl, alen - 1)));
}
