#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


/*****************************************************************************

	OBSOLETE - Use inthdl_shift_{left,right}

*****************************************************************************/


#if 0
void
inthdl_truncate WITH_3_ARGS(
    inthdl_handle,  ahdl,
    integer_small,  n,
    inthdl_handle,  result
)
/*
**  Input:  ahdl - t_handle to an infinite-precision integer
**          n - a beta-digit (see below)
**  Output: result - t_handle to an infinite precision integer
**          which is the integral part of (integer ahdl / 2^n)
*/
{
    inthdl_length   alen;
    inthdl_length   rlen;
    integer_small   nabs;
    integer_small   quot;
    integer_small   rem;
    integer_small   rpower;
    integer_small   i;
    inthdl_handle   tempr;

    DEBUG_INTHDL_BETA("+inthdl_truncate", ahdl, n);

    if ((intbig_sign(result) = intbig_sign(ahdl)) == 0)
    {
	intbig_sign(result) = 0;
	DEBUG_INTHDL_1("-inthdl_truncate", result);
	return;
    }

    alen = intbig_curr_size(ahdl);

    if (n == 0)
    {
	if (ahdl != result)
	{
	    intbig_copy_digits(ahdl, 0, alen, result, 0);
	    intbig_curr_size(result) = alen;
	}
	DEBUG_INTHDL_1("-inthdl_truncate", result);
	return;
    }

    /*
     *  non-zero... ->  find quot, rem s.t. |n| = quot * zeta + rem
     */

    nabs = (n < 0) ? (-n) : (n);
    quot = nabs / ZETA;
    rem = nabs - quot * ZETA;
    rpower = 1 << ((rem + 1) - 1);

    DEBUG_INTEGER(".quot, rem, alen", 4, quot, rem, alen, rpower);

    /*
     *  if n is positive ...
     */

    if (n > 0)
    {
	if (quot > alen)
	{
	    intbig_sign(result) = 0;
	    DEBUG_INTHDL_1("-inthdl_truncate", result);
	    return;
	}

	intbig_curr_size(result) = rlen = alen - quot;
	intbig_copy_digits(ahdl, quot, rlen, result, 0)

	if (rem)
	{
	    tempr = inthdl_buf_alloc(rlen);
	    inthdl_quot_rem_beta(result, rpower, tempr, &rem);
	    rlen = intbig_curr_size(tempr);
	    intbig_copy_digits(tempr, 0, rlen, result, 0);
	    intbig_curr_size(result) = rlen;
	    inthdl_buf_delete(tempr);
	}

	DEBUG_INTHDL_1("-inthdl_truncate", result);
	return;
    }

    /*
     *  n is negative.
     */

    if (rem)
    {
	inthdl_mult_beta(ahdl, rpower, result);
	rlen = intbig_curr_size(result);
    }
    else
    {
	intbig_copy_digits(ahdl, 0, alen, result, 0);
	intbig_curr_size(result) = rlen = alen;
    }

    if (quot == 0)
    {
	DEBUG_INTHDL_1("-inthdl_truncate", result);
	return;
    }

    tempr = inthdl_buf_alloc(rlen);
    intbig_copy_digits(result, 0, rlen, tempr, 0);

    for (i = 0; i < quot; i++)
	intbig_digit(result, i) = 0;

    intbig_copy_digits(tempr, 0, rlen, result, quot);
    inthdl_buf_delete(tempr);
    intbig_curr_size(result) = rlen + quot;

    DEBUG_INTHDL_1("-inthdl_truncate", result);
}
#endif
